/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

import com.intel.stl.api.subnet.NodeType;
import java.util.BitSet;

public class NodeState {
    private final NodeType type;
    private final BitSet ports;
    private final int numPorts;

    public NodeState(NodeType type, int numPorts) {
        this.type = type;
        this.ports = new BitSet();
        this.numPorts = numPorts;
    }

    public NodeType getType() {
        return this.type;
    }

    public void setActivePort(short portNum) {
        this.ports.set(portNum);
    }

    public boolean isActivePort(short portNum) {
        if (portNum == 0 && this.type == NodeType.SWITCH) {
            return true;
        }
        return this.ports.get(portNum);
    }

    public int numActicePorts(boolean countInternalMgrPort) {
        if (countInternalMgrPort && this.type == NodeType.SWITCH) {
            return this.ports.cardinality() + 1;
        }
        return this.ports.cardinality();
    }

    public int getNumPorts(boolean countInternalMgrPort) {
        if (countInternalMgrPort && this.type == NodeType.SWITCH) {
            return this.numPorts + 1;
        }
        return this.numPorts;
    }

    public String toString() {
        return "NodeState [type=" + (Object)((Object)this.type) + ", numPorts=" + this.numPorts + ", ports=" + this.ports + "]";
    }
}

