/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class PasswordField {
    private static String CLEAR_THREAD_NAME = "pf-thread";
    private static int DEFAULT_LIFE_TIME = 3000;
    private final int lifetime;
    protected final AtomicLong expiration = new AtomicLong();
    private final AtomicReference<char[]> pwd = new AtomicReference<Object>(null);
    protected Thread clearThread;

    public PasswordField() {
        this(DEFAULT_LIFE_TIME);
    }

    public PasswordField(int lifetime) {
        this.lifetime = lifetime;
    }

    public void setPassword(char[] password) {
        char[] currpwd = this.pwd.get();
        while (!this.pwd.compareAndSet(currpwd, password)) {
            currpwd = this.pwd.get();
        }
        if (currpwd != null) {
            for (int i = 0; i < currpwd.length; ++i) {
                currpwd[i] = '\u0000';
            }
        }
        if (this.pwd.get() == null) {
            this.stopClearThread();
        } else {
            this.startClearThread();
            this.resetExpiration();
        }
    }

    public char[] getPassword() {
        this.resetExpiration();
        char[] work = this.pwd.get();
        return work == null ? null : Arrays.copyOf(work, work.length);
    }

    private void startClearThread() {
        if (this.clearThread == null) {
            this.clearThread = this.createThread(new Runnable(){

                @Override
                public void run() {
                    do {
                        try {
                            PasswordField.this.waitForExpiration();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    } while (PasswordField.this.clearThread != null && !PasswordField.this.clearThread.isInterrupted() && System.currentTimeMillis() < PasswordField.this.expiration.get());
                    if (PasswordField.this.clearThread != null && !PasswordField.this.clearThread.isInterrupted()) {
                        PasswordField.this.setPassword(null);
                    }
                }
            });
            this.clearThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopClearThread() {
        if (this.clearThread != null) {
            Thread thread = this.clearThread;
            synchronized (thread) {
                this.clearThread.interrupt();
            }
            this.clearThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetExpiration() {
        if (this.clearThread != null) {
            Thread thread = this.clearThread;
            synchronized (thread) {
                this.expiration.set(System.currentTimeMillis() + (long)this.lifetime);
                this.clearThread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForExpiration() throws InterruptedException {
        Thread thread = this.clearThread;
        synchronized (thread) {
            this.clearThread.wait(this.expiration.get() - System.currentTimeMillis());
        }
    }

    protected Thread createThread(Runnable runnable) {
        Thread newThread = new Thread(runnable);
        newThread.setName(CLEAR_THREAD_NAME);
        return newThread;
    }
}

