/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SafeExchanger<V>
extends Exchanger<V> {
    private int timeout = 50;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be a positive value!");
        }
        this.timeout = timeout;
    }

    @Override
    public V exchange(V x) throws InterruptedException {
        try {
            return super.exchange(x, this.timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Time out after " + this.timeout + " seconds!");
        }
    }
}

