/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.Arrays;

public enum FlitDistanceMode {
    NOP(0),
    MODE_1(1),
    MODE_2(2);

    private final byte value;

    private FlitDistanceMode(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static FlitDistanceMode getFlitDistanceMode(byte value) {
        for (FlitDistanceMode mode : FlitDistanceMode.values()) {
            if (mode.value != value) continue;
            return mode;
        }
        throw new IllegalArgumentException("Unsupported FlitDistanceMode " + StringUtils.byteHexString(value));
    }

    public static FlitDistanceMode[] getFlitDistanceModes(byte value) {
        if (FlitDistanceMode.isNoneSupported(value)) {
            return new FlitDistanceMode[]{NOP};
        }
        FlitDistanceMode[] allModes = FlitDistanceMode.values();
        FlitDistanceMode[] modes = new FlitDistanceMode[allModes.length];
        int numFormats = 0;
        for (FlitDistanceMode pdm : allModes) {
            if (pdm == NOP || (pdm.value & value) != pdm.value) continue;
            modes[numFormats] = pdm;
            ++numFormats;
        }
        return Arrays.copyOf(modes, numFormats);
    }

    public static boolean isNoneSupported(byte value) {
        return value == FlitDistanceMode.NOP.value;
    }
}

