/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.ArrayList;
import java.util.List;

public enum PortErrorAction {
    EXCESSIVE_BUFFER_OVERRUN(Integer.MIN_VALUE),
    FM_CONFIG_ERROR_EXCEEDMULTICASTLIMIT(0x800000),
    FM_CONFIG_ERROR_BADCONTROLFLIT(0x400000),
    FM_CONFIG_ERROR_BADPREEMPT(0x200000),
    FM_CONFIG_ERROR_UNSUPPORTEDVLMARKER(0x100000),
    FM_CONFIG_ERROR_BADCRDTACK(524288),
    FM_CONFIG_ERROR_BADCTRLDIST(262144),
    FM_CONFIG_ERROR_BADTAILDIST(131072),
    FM_CONFIG_ERROR_BADHEADDIST(65536),
    PORT_RCV_ERROR_BADVLMARKER(8192),
    PORT_RCV_ERROR_PREEMPTVL15(4096),
    PORT_RCV_ERROR_PREEMPTERROR(2048),
    PORT_RCV_ERROR_BADMIDTAIL(512),
    PORT_RCV_ERROR_RESERVED(256),
    PORT_RCV_ERROR_BADSC(128),
    PORT_RCV_ERROR_BADL2(64),
    PORT_RCV_ERROR_BADDLID(32),
    PORT_RCV_ERROR_BADSLID(16),
    PORT_RCV_ERROR_PKTLENTOOSHORT(8),
    PORT_RCV_ERROR_PKTLENTOOLONG(4),
    PORT_RCV_ERROR_BADPKTLEN(2);

    private final int mask;

    private PortErrorAction(int mask) {
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    public static PortErrorAction getPortErrorAction(int value) {
        for (PortErrorAction pea : PortErrorAction.values()) {
            if (pea.mask != value) continue;
            return pea;
        }
        throw new IllegalArgumentException("Unsupported PortErrorAction " + StringUtils.intHexString(value));
    }

    public static List<PortErrorAction> getPortErroActions(int value) {
        ArrayList<PortErrorAction> errorActions = new ArrayList<PortErrorAction>();
        for (PortErrorAction pea : PortErrorAction.values()) {
            if ((value & pea.mask) != pea.mask) continue;
            errorActions.add(pea);
        }
        return errorActions;
    }
}

