/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.configuration.ResourceType;
import java.util.HashMap;
import java.util.Map;

public enum ResourceCategory {
    NODE_INFO(ResourceType.HFI, ResourceType.SWITCH),
    DEVICE_GROUPS(ResourceType.HFI, ResourceType.SWITCH),
    LINK_WIDTH(ResourceType.PORT),
    LINK_WIDTH_DOWNGRADE(ResourceType.PORT),
    LINK_SPEED(ResourceType.PORT),
    LINK_CONNECTED_TO(ResourceType.PORT),
    NEIGHBOR_MODE(ResourceType.PORT),
    NODE_PORT_INFO(ResourceType.HFI, ResourceType.SWITCH),
    PORT_INFO(ResourceType.PORT),
    PORT_LINK_MODE(ResourceType.PORT),
    PORT_LTP_CRC_MODE(ResourceType.PORT),
    PORT_MODE(ResourceType.PORT),
    PORT_PACKET_FORMAT(ResourceType.PORT),
    PORT_ERROR_ACTIONS(ResourceType.PORT),
    PORT_BUFFER_UNITS(ResourceType.PORT),
    PORT_IPADDR(ResourceType.PORT),
    PORT_SUBNET(ResourceType.PORT),
    PORT_CAPABILITIES(ResourceType.PORT),
    PORT_DIAGNOSTICS(ResourceType.PORT),
    PORT_MANAGEMENT(ResourceType.PORT),
    PORT_PARTITION_ENFORCEMENT(ResourceType.PORT),
    FLIT_CTRL_INTERLEAVE(ResourceType.PORT),
    FLIT_CTRL_PREEMPTION(ResourceType.PORT),
    HOQLIFE_CHART(ResourceType.PORT),
    VIRTUAL_LANE(ResourceType.PORT),
    VL_STALL_CHART(ResourceType.PORT),
    MTU_CHART(ResourceType.PORT),
    CABLE_INFO(ResourceType.PORT),
    SC2SLMT_CHART(ResourceType.HFI, ResourceType.SWITCH),
    SC2VLTMT_CHART(ResourceType.PORT),
    SC2VLNTMT_CHART(ResourceType.PORT),
    LINK_DOWN_ERROR_LOG(ResourceType.PORT),
    NEIGHBOR_LINK_DOWN_ERROR_LOG(ResourceType.PORT),
    SWITCH_INFO(ResourceType.SWITCH),
    SWITCH_FORWARDING(ResourceType.SWITCH),
    SWITCH_ROUTING(ResourceType.SWITCH),
    SWITCH_IPADDR(ResourceType.SWITCH),
    SWITCH_PARTITION_ENFORCEMENT(ResourceType.SWITCH),
    SWITCH_ADAPTIVE_ROUTING(ResourceType.SWITCH),
    MFT_TABLE(ResourceType.SWITCH),
    LFT_HISTOGRAM(ResourceType.SWITCH),
    LFT_TABLE(ResourceType.SWITCH);

    private static final Map<String, ResourceCategory> categoryMap;
    private final ResourceType[] resourceTypes;

    private ResourceCategory(ResourceType ... resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public boolean isApplicableTo(ResourceType resourceType) {
        for (int i = 0; i < this.resourceTypes.length; ++i) {
            if (this.resourceTypes[i] != resourceType) continue;
            return true;
        }
        return false;
    }

    public static ResourceCategory getResourceCategoryFor(String categoryName) {
        ResourceCategory res = categoryMap.get(categoryName);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Unsupported ResourceCategory '" + categoryName + "'");
    }

    static {
        categoryMap = new HashMap<String, ResourceCategory>();
        for (ResourceCategory rc : ResourceCategory.values()) {
            categoryMap.put(rc.name(), rc);
        }
    }
}

