/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;

public enum StaticRate {
    UNLIMITED(0, "Unlimited"),
    RATE_14G(2, "12.5g"),
    RATE_25GB(1, "25g"),
    RATE_40GB(2, "37.5g"),
    RATE_56GB(2, "50g"),
    RATE_80GB(1, "75g"),
    RATE_100G(2, "100g");

    private final byte id;
    private final String name;

    private StaticRate(byte id, String name) {
        this.id = id;
        this.name = name;
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static StaticRate getStaticRate(byte inval) {
        for (StaticRate sr : StaticRate.values()) {
            if (sr.getId() != inval) continue;
            return sr;
        }
        throw new IllegalArgumentException("Unsupported StaticRate " + StringUtils.byteHexString(inval));
    }

    public static StaticRate getStaticRate(String name) {
        for (StaticRate sr : StaticRate.values()) {
            if (!sr.getName().equalsIgnoreCase(name)) continue;
            return sr;
        }
        throw new IllegalArgumentException("Unsupported StaticRate '" + name + "'");
    }
}

