/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration.impl;

import com.intel.stl.api.AppContext;
import com.intel.stl.api.ICertsAssistant;
import com.intel.stl.api.ISecurityHandler;
import com.intel.stl.api.StartupProgressObserver;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.SubnetContext;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.IConfigurationApi;
import com.intel.stl.api.configuration.impl.ConfigurationApi;
import com.intel.stl.api.configuration.impl.MailManager;
import com.intel.stl.api.configuration.impl.SubnetContextImpl;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.api.subnet.SubnetException;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppComponent;
import com.intel.stl.configuration.AppComponentRegistry;
import com.intel.stl.configuration.AppConfig;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.configuration.AsyncProcessingService;
import com.intel.stl.configuration.SerialProcessingService;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.fecdriver.adapter.IAdapter;
import com.intel.stl.fecdriver.adapter.ISMEventListener;
import com.intel.stl.fecdriver.session.ISession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppContextImpl
implements AppComponent,
AppContext {
    private static Logger log = LoggerFactory.getLogger(AppContextImpl.class);
    private static final String APPCONTEXT_COMPONENT = STLMessages.STL10020_APPCONTEXT_COMPONENT.getDescription();
    private static final String PROGRESS_MESSAGE = STLMessages.STL10025_STARTING_COMPONENT.getDescription(APPCONTEXT_COMPONENT);
    private static final String SHUTDOWN_MESSAGE = STLMessages.STL10026_STOPPING_COMPONENT.getDescription(APPCONTEXT_COMPONENT);
    private final IAdapter adapter;
    private final DatabaseManager dbMgr;
    private final MailManager mailMgr;
    private final SerialProcessingService processingService;
    private final Map<String, SubnetDescription> subnetsBySubnetName = new HashMap<String, SubnetDescription>();
    private final Map<SubnetDescription, SubnetContext> subnetContexts = new HashMap<SubnetDescription, SubnetContext>();
    private IConfigurationApi confApi;
    private AppSettings settings;
    private final AtomicInteger threadCount = new AtomicInteger(1);

    public AppContextImpl(IAdapter adapter, DatabaseManager dbMgr, MailManager mailMgr, AsyncProcessingService processingService) {
        this.adapter = adapter;
        this.dbMgr = dbMgr;
        this.mailMgr = mailMgr;
        this.processingService = processingService;
    }

    public MailManager getMailMgr() {
        return this.mailMgr;
    }

    @Override
    public void registerCertsAssistant(ICertsAssistant assistant) {
        this.adapter.registerCertsAssistant(assistant);
    }

    @Override
    public void registerSecurityHandler(ISecurityHandler securityHandler) {
        this.adapter.registerSecurityHandler(securityHandler);
    }

    @Override
    public void initialize(AppSettings settings, StartupProgressObserver observer) throws AppConfigurationException {
        if (observer != null) {
            observer.setProgress(PROGRESS_MESSAGE);
        }
        this.settings = settings;
        this.confApi = new ConfigurationApi(this.adapter, this.dbMgr, this.mailMgr, settings);
    }

    @Override
    public String getComponentDescription() {
        return APPCONTEXT_COMPONENT;
    }

    @Override
    public int getInitializationWeight() {
        return 15;
    }

    @Override
    public List<SubnetDescription> getSubnets() {
        return this.dbMgr.getSubnets();
    }

    @Override
    public SubnetContext getSubnetContextFor(SubnetDescription subnet) {
        return this.getSubnetContextFor(subnet, false);
    }

    @Override
    public SubnetContext getSubnetContextFor(SubnetDescription subnet, boolean startBackgroundTasks) {
        SubnetDescription dbSubnet = this.getSubnet(subnet.getName());
        dbSubnet.setContent(subnet);
        boolean subnetContextCreated = this.isSubnetContextCreated(dbSubnet);
        if (!subnetContextCreated) {
            this.addSubnetContext(dbSubnet, startBackgroundTasks);
        }
        SubnetContext subnetContext = this.subnetContexts.get(dbSubnet);
        return subnetContext;
    }

    @Override
    public String getAppSetting(String settingName, String defaultValue) {
        if (this.settings != null) {
            return this.settings.getConfigOption(settingName, defaultValue);
        }
        return defaultValue;
    }

    private boolean isSubnetContextCreated(SubnetDescription subnet) {
        SubnetContext context = this.subnetContexts.get(subnet);
        return context != null && context.isValid() && !context.isClosed();
    }

    private void addSubnetContext(SubnetDescription subnet, boolean startBackgroundTasks) {
        SubnetContext context = this.subnetContexts.get(subnet);
        if (context == null || !context.isValid() || context.isClosed()) {
            log.info("Creating SubnetContext for subnet " + subnet.getName() + " with startBackgroundTasks=" + startBackgroundTasks);
            this.createSubnetContext(subnet, startBackgroundTasks);
        }
    }

    protected synchronized void createSubnetContext(SubnetDescription subnet, boolean startBackgroundTasks) {
        SubnetContext oldContext;
        SubnetContext context = this.subnetContexts.get(subnet);
        if ((context == null || !context.isValid() || context.isClosed()) && (oldContext = this.subnetContexts.put(subnet, context = new SubnetContextImpl(subnet, this))) != null) {
            oldContext.cleanup();
        }
    }

    @Override
    public IConfigurationApi getConfigurationApi() {
        return this.confApi;
    }

    @Override
    public void shutdown(StartupProgressObserver observer) {
        if (observer != null) {
            observer.setProgress(SHUTDOWN_MESSAGE);
        }
        this.processingService.shutdown();
        for (SubnetContext subnetCtx : this.subnetContexts.values()) {
            try {
                subnetCtx.cleanup();
            }
            catch (Exception e) {
                log.error("Error shutting down SubnetContext", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        log.info("Starting application shutdown");
        AppComponentRegistry registry = AppConfig.getAppComponentRegistry();
        try {
            registry.shutdown();
        }
        finally {
            log.info("Application component shutdown complete");
            System.gc();
            System.exit(0);
        }
    }

    public DatabaseManager getDatabaseManager() {
        return this.dbMgr;
    }

    public SerialProcessingService getProcessingService() {
        return this.processingService;
    }

    public int getNoticeManagerThreadCount() {
        return this.threadCount.getAndIncrement();
    }

    protected SubnetDescription getSubnet(String subnetName) throws SubnetException {
        SubnetDescription subnet = this.subnetsBySubnetName.get(subnetName);
        if (subnet == null) {
            subnet = this.insertNewSubnet(subnetName);
        }
        return subnet;
    }

    protected synchronized SubnetDescription insertNewSubnet(String subnetName) {
        SubnetDescription subnet = this.dbMgr.getSubnet(subnetName);
        if (subnet == null) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL30022_SUBNET_NOT_FOUND, subnetName);
            throw ce;
        }
        long subnetId = subnet.getSubnetId();
        Iterator<SubnetDescription> it = this.subnetsBySubnetName.values().iterator();
        while (it.hasNext()) {
            if (it.next().getSubnetId() != subnetId) continue;
            it.remove();
        }
        this.subnetsBySubnetName.put(subnetName, subnet);
        return subnet;
    }

    protected ISession createSession(SubnetDescription subnet, ISMEventListener listener) {
        try {
            ISession session = this.adapter.createSession(subnet, listener);
            if (session != null) {
                session.getSubnetDescription().setName(subnet.getName());
            }
            return session;
        }
        catch (Exception e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50008_SUBNET_CONNECTION_ERROR, (Throwable)e, new Object[]{subnet.getName(), StringUtils.getErrorMessage(e)});
            log.error(StringUtils.getErrorMessage(e), (Throwable)e);
            throw ce;
        }
    }

    public Map<SubnetDescription, SubnetContext> getSubnetContexts() {
        return this.subnetContexts;
    }
}

