/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration.impl;

import com.intel.stl.api.StartupProgressObserver;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.api.configuration.MailProperties;
import com.intel.stl.api.configuration.impl.MailSender;
import com.intel.stl.api.notice.GenericNoticeAttrBean;
import com.intel.stl.api.notice.IEmailEventListener;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.NoticeType;
import com.intel.stl.api.notice.TrapType;
import com.intel.stl.api.subnet.GIDGlobal;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppComponent;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailManager
implements AppComponent {
    private static Logger log = LoggerFactory.getLogger(MailManager.class);
    private static final String MAIL_COMPONENT = STLMessages.STL10019_MAIL_COMPONENT.getDescription();
    private static final String PROGRESS_MESSAGE = STLMessages.STL10025_STARTING_COMPONENT.getDescription(MAIL_COMPONENT);
    private static final String SHUTDOWN_MESSAGE = STLMessages.STL10026_STOPPING_COMPONENT.getDescription(MAIL_COMPONENT);
    private final String SMTP_FROM_ADDRESS = "smtp_from_address";
    private final String SMTP_PORT = "smtp_port";
    private final String SMTP_SERVER_NAME = "smtp_server_name";
    private final String SMTP_NOTIFICATIONS_ENABLED = "smtp_notifications_enabled";
    private MailSender mailSender;
    private MailProperties mailProperties;
    private final DatabaseManager databaseManager;
    private final List<IEmailEventListener<NoticeBean>> emailEventListeners = new CopyOnWriteArrayList<IEmailEventListener<NoticeBean>>();
    private boolean isSmtpValid = false;
    private final List<NoticeBean> toSend = new ArrayList<NoticeBean>();

    public MailManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    @Override
    public void initialize(AppSettings settings, StartupProgressObserver observer) throws AppConfigurationException {
        if (observer != null) {
            observer.setProgress(PROGRESS_MESSAGE);
        }
        this.initializeSmtpSettings();
    }

    @Override
    public String getComponentDescription() {
        return STLMessages.STL10019_MAIL_COMPONENT.getDescription();
    }

    @Override
    public int getInitializationWeight() {
        return 5;
    }

    public void initializeSmtpSettings() {
        this.mailProperties = this.getStoredMailProperties();
        if (!this.mailProperties.getEmailNotificationsEnabled()) {
            return;
        }
        if (this.isValidMailProperties(this.mailProperties)) {
            this.createMailSender();
            this.isSmtpValid = true;
        } else {
            this.isSmtpValid = false;
            NoticeBean notice = this.createInvalidSMTPSettingsNotice();
            this.fireNotice(new NoticeBean[]{notice});
        }
    }

    public synchronized void updateMailProperties(MailProperties properties) {
        if (this.isValidMailProperties(properties)) {
            this.isSmtpValid = true;
        } else {
            NoticeBean notice = this.createInvalidSMTPSettingsNotice();
            this.isSmtpValid = false;
            this.fireNotice(new NoticeBean[]{notice});
        }
        this.mailProperties = properties;
        if (properties.getEmailNotificationsEnabled() && this.isSmtpValid) {
            this.createMailSender();
        } else {
            this.mailSender = null;
        }
        this.storeMailProperties(properties);
    }

    public MailProperties getMailProperties() {
        return this.mailProperties;
    }

    public boolean isSmtpSettingsValid() {
        return this.isSmtpValid;
    }

    public void sendTestMail(MailProperties properties, String recipient, String messageSubject, String messageBody) {
        try {
            MailSender.sendTestMail(properties, recipient, messageSubject, messageBody);
        }
        catch (MessagingException e) {
            NoticeBean bean = this.createInvalidSMTPSettingsNotice();
            this.fireNotice(new NoticeBean[]{bean});
        }
    }

    public void submitMessage(String subject, String body, List<String> recipients) {
        if (this.mailSender != null) {
            for (String recipient : recipients) {
                this.mailSender.submitMessage(recipient, subject, body);
            }
        } else {
            log.debug("MailManager: MailSender is null during submitMessage");
        }
    }

    @Override
    public void shutdown(StartupProgressObserver observer) {
        if (observer != null) {
            observer.setProgress(SHUTDOWN_MESSAGE);
        }
        try {
            if (this.mailSender != null) {
                this.mailSender.shutdown();
            }
        }
        catch (Throwable e) {
            log.warn(StringUtils.getErrorMessage(e), e);
        }
    }

    protected void createMailSender() {
        if (this.mailSender == null) {
            try {
                this.mailSender = new MailSender(this.mailProperties);
            }
            catch (MessagingException e) {
                NoticeBean bean = this.createInvalidSMTPSettingsNotice();
                this.fireNotice(new NoticeBean[]{bean});
            }
        } else {
            try {
                this.mailSender.updateTransport(this.mailProperties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.debug("MailManager: updateMailProperties called.");
    }

    protected MailProperties getStoredMailProperties() {
        AppInfo appInfo = this.databaseManager.getAppInfo();
        return this.unpackStoredMailProperties(appInfo);
    }

    protected void storeMailProperties(MailProperties mailProperties) {
        AppInfo appInfo = this.databaseManager.getAppInfo();
        Map<String, Properties> appProperties = appInfo.getPropertiesMap();
        Properties smtpProperties = this.packMailProperties(mailProperties);
        appProperties.put("SMTPSettings", smtpProperties);
        this.databaseManager.saveAppProperties(appProperties);
    }

    protected MailProperties unpackStoredMailProperties(AppInfo appInfo) {
        Properties smtpProperties;
        MailProperties mailProperties = new MailProperties();
        if (appInfo != null && (smtpProperties = appInfo.getProperty("SMTPSettings")) != null) {
            String serverName;
            String portString;
            String fromAddress = smtpProperties.getProperty("smtp_from_address");
            if (fromAddress != null) {
                mailProperties.setFromAddr(fromAddress);
            }
            if ((portString = smtpProperties.getProperty("smtp_port")) != null) {
                mailProperties.setSmtpPort(new Integer(portString));
            }
            if ((serverName = smtpProperties.getProperty("smtp_server_name")) != null) {
                mailProperties.setSmtpServer(serverName);
            }
            boolean enableEmailNotifications = Boolean.parseBoolean(smtpProperties.getProperty("smtp_notifications_enabled"));
            mailProperties.setEmailNotificationsEnabled(enableEmailNotifications);
        }
        return mailProperties;
    }

    protected Properties packMailProperties(MailProperties properties) {
        Properties smtpProperties = new Properties();
        smtpProperties.setProperty("smtp_from_address", properties.getFromAddr());
        smtpProperties.setProperty("smtp_port", new Integer(properties.getSmtpPort()).toString());
        smtpProperties.setProperty("smtp_server_name", properties.getSmtpServer());
        smtpProperties.setProperty("smtp_notifications_enabled", Boolean.toString(properties.getEmailNotificationsEnabled()));
        return smtpProperties;
    }

    protected boolean isValidMailProperties(MailProperties properties) {
        boolean isValid = false;
        if (properties != null && !properties.getSmtpServer().isEmpty() && properties.getSmtpPort() >= 0 && !properties.getFromAddr().isEmpty()) {
            isValid = true;
        }
        return isValid;
    }

    protected NoticeBean createInvalidSMTPSettingsNotice() {
        NoticeBean bean = new NoticeBean(true);
        GenericNoticeAttrBean attr = new GenericNoticeAttrBean();
        attr.setGeneric(true);
        attr.setType(NoticeType.INFO.getId());
        attr.setTrapNumber(TrapType.SMTP_SETTINGS_INVALID.getId());
        bean.setAttributes(attr);
        bean.setData(STLMessages.STL70000_SMTP_UNABLE_TO_CONNECT.getDescription().getBytes());
        bean.setIssuerGID(new GIDGlobal());
        bean.setClassData(new byte[0]);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotice(NoticeBean[] notices) {
        log.info("Fire " + notices.length + " notices " + Arrays.toString(notices));
        if (this.emailEventListeners.isEmpty()) {
            List<NoticeBean> list = this.toSend;
            synchronized (list) {
                for (NoticeBean notice : notices) {
                    this.toSend.add(notice);
                }
            }
        }
        for (IEmailEventListener<NoticeBean> listener : this.emailEventListeners) {
            try {
                listener.onNewEvent((NoticeBean[])notices);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmailEventListener(IEmailEventListener<NoticeBean> listener) {
        this.emailEventListeners.add(listener);
        List<NoticeBean> list = this.toSend;
        synchronized (list) {
            if (!this.toSend.isEmpty()) {
                NoticeBean[] data = this.toSend.toArray(new NoticeBean[0]);
                this.toSend.clear();
                listener.onNewEvent((NoticeBean[])data);
            }
        }
    }

    public void removeEmailListener(IEmailEventListener<NoticeBean> listener) {
        this.emailEventListeners.remove(listener);
    }

    public boolean isEmailValid(String email) {
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            return false;
        }
        return true;
    }
}

