/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.logs;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.common.STLMessages;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FMConfigParser {
    private static final Logger log = LoggerFactory.getLogger(FMConfigParser.class);
    private static final String XPATH_LOG_FILE = "/Config/Common/Shared/LogFile";
    private XPath xPath;
    private Document config;
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static XPathFactory xPathFactory = XPathFactory.newInstance();
    private final FMConfHelper fmConfigHelper;
    private File fmConfigFile;

    public FMConfigParser(FMConfHelper fmConfigHelper) {
        this.fmConfigHelper = fmConfigHelper;
    }

    public String getLogFilePath(char[] password) throws Exception {
        String logFilePath = null;
        this.xPath = xPathFactory.newXPath();
        try {
            this.fmConfigFile = this.fmConfigHelper.getConfFile();
            if (this.fmConfigFile == null) {
                this.fmConfigHelper.fetchConfigFile(password);
                this.fmConfigFile = this.fmConfigHelper.getConfFile();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Node node = this.getLogFileNode();
        if (node != null) {
            logFilePath = node.getFirstChild().getNodeValue();
        }
        return logFilePath;
    }

    protected Node getLogFileNode() {
        Document config = this.getConfig();
        try {
            Node logFileNode = (Node)this.xPath.evaluate(XPATH_LOG_FILE, config, XPathConstants.NODE);
            return logFileNode;
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_LOG_FILE);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    protected Document getConfig() {
        if (this.config == null) {
            try {
                DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
                this.config = db.parse(this.fmConfigFile);
            }
            catch (Exception e) {
                ConfigurationException ce = new ConfigurationException(STLMessages.STL50013_ERROR_PARSING_FM_CONFIG, StringUtils.getErrorMessage(e));
                log.error(ce.getMessage(), (Throwable)e);
                throw ce;
            }
        }
        return this.config;
    }
}

