/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.logs;

import com.intel.stl.api.logs.FileInfoBean;
import com.intel.stl.api.logs.ILogPageListener;
import com.intel.stl.api.logs.LogMessageType;

public class LogCommander {
    public static final String RESPONSE_EOM = "intel-inside";
    private ILogPageListener logPageListener;
    private FileInfoBean fileInfo;

    public LogCommander(FileInfoBean fileInfo) {
        this.fileInfo = fileInfo;
    }

    public void setPageMonitorListener(ILogPageListener listener) {
        this.logPageListener = listener;
    }

    public FileInfoBean getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfoBean fileInfo) {
        this.fileInfo = fileInfo;
    }

    public synchronized String getCommand(LogMessageType cmdType, long numLinesRequested) {
        String cmdStr = null;
        switch (cmdType) {
            case CHECK_FOR_FILE: {
                cmdStr = this.checkForFile(this.fileInfo);
                break;
            }
            case CHECK_FILE_ACCESS: {
                cmdStr = this.checkFileAccess(this.fileInfo);
                break;
            }
            case PREVIOUS_PAGE: {
                cmdStr = this.getPreviousPage(this.fileInfo, numLinesRequested);
                break;
            }
            case NEXT_PAGE: {
                cmdStr = this.getNextPage(numLinesRequested, this.fileInfo);
                break;
            }
            case NUM_LINES: {
                cmdStr = this.getNumLines(this.fileInfo);
                break;
            }
            case LAST_LINES: {
                cmdStr = this.getEndOfFile(this.fileInfo, numLinesRequested);
                break;
            }
            case FILE_SIZE: {
                cmdStr = this.getFileSize(this.fileInfo);
                break;
            }
        }
        cmdStr = cmdStr + "; echo intel-inside";
        return cmdStr;
    }

    protected synchronized String checkForFile(FileInfoBean fileInfo) {
        String cmdStr = null;
        cmdStr = "ls " + fileInfo.getFileName();
        return cmdStr;
    }

    protected synchronized String checkFileAccess(FileInfoBean fileInfo) {
        String cmdStr = null;
        cmdStr = "tail " + fileInfo.getFileName() + " > /dev/null > 2&>1; echo $?";
        return cmdStr;
    }

    protected synchronized String getPreviousPage(FileInfoBean fileInfo, long numLinesRequested) {
        String cmdStr = null;
        String fileName = fileInfo.getFileName();
        long currentLine = fileInfo.getCurrentLine();
        long newCurrentLine = currentLine >= numLinesRequested ? currentLine - numLinesRequested : 1L;
        boolean topOfFile = currentLine - 1L < numLinesRequested;
        long endLine = topOfFile ? numLinesRequested : currentLine - 1L;
        cmdStr = topOfFile ? "head -n " + endLine + " " + fileName : "head -n " + endLine + " " + fileName + " | tail -n " + numLinesRequested;
        fileInfo.setCurrentLine(newCurrentLine);
        if (newCurrentLine > 0L) {
            this.logPageListener.setStartLine(newCurrentLine);
            this.logPageListener.setEndLine(endLine);
        }
        if (fileInfo.getCurrentLine() == 1L) {
            this.logPageListener.setFirstPage(true);
            this.logPageListener.setLastPage(false);
        } else {
            this.logPageListener.setFirstPage(false);
            this.logPageListener.setLastPage(false);
        }
        return cmdStr;
    }

    protected synchronized String getNextPage(long numLinesRequested, FileInfoBean fileInfo) {
        long currentTotalNumLines;
        String cmdStr = null;
        String fileName = fileInfo.getFileName();
        long currentLine = fileInfo.getCurrentLine();
        long newCurrentLine = currentLine + numLinesRequested;
        long newEndLine = newCurrentLine + numLinesRequested - 1L;
        if (newEndLine > (currentTotalNumLines = fileInfo.getTotalNumLines())) {
            newCurrentLine = currentTotalNumLines - numLinesRequested + 1L;
            newEndLine = currentTotalNumLines;
            if (newCurrentLine < 0L) {
                newCurrentLine = currentLine;
            }
        }
        cmdStr = "head -n " + newEndLine + " " + fileName + " | tail -n " + numLinesRequested;
        fileInfo.setCurrentLine(newCurrentLine);
        if (newCurrentLine > 0L) {
            this.logPageListener.setStartLine(newCurrentLine);
            this.logPageListener.setEndLine(newEndLine);
        }
        if (newEndLine >= currentTotalNumLines) {
            this.logPageListener.setLastPage(true);
            if (currentTotalNumLines > numLinesRequested) {
                this.logPageListener.setFirstPage(false);
            } else {
                this.logPageListener.setFirstPage(true);
            }
        } else {
            this.logPageListener.setFirstPage(false);
            this.logPageListener.setLastPage(false);
        }
        return cmdStr;
    }

    protected synchronized String getNumLines(FileInfoBean fileInfo) {
        String cmdStr = null;
        String fileName = fileInfo.getFileName();
        long oldSize = fileInfo.getFileSize();
        String newSize = "newSize=`ls -l " + fileName + " | awk '{print $5}'`; ";
        String diffSize = "diffSize=$(echo `expr \"$newSize\" - " + oldSize + "`); ";
        String getNewSize = "echo \"newSize=$newSize\";";
        String getNumLines = "echo \"numLines=`tail -c $diffSize " + fileName + " | wc -l`\"";
        cmdStr = newSize + diffSize + getNewSize + getNumLines;
        fileInfo.update(oldSize, fileInfo.getTotalNumLines());
        return cmdStr;
    }

    protected synchronized String getEndOfFile(FileInfoBean fileInfo, long numLinesRequested) {
        String cmdStr = null;
        long totalNumLines = fileInfo.getTotalNumLines();
        String fileName = fileInfo.getFileName();
        long newCurrentLine = totalNumLines < numLinesRequested ? 1L : (fileInfo.getCurrentLine() <= 0L ? totalNumLines : totalNumLines - numLinesRequested + 1L);
        cmdStr = this.getNumLines(fileInfo) + ";";
        cmdStr = cmdStr + "tail -n " + numLinesRequested + " " + fileName;
        fileInfo.setCurrentLine(newCurrentLine);
        if (numLinesRequested >= totalNumLines) {
            this.logPageListener.setFirstPage(true);
            this.logPageListener.setLastPage(true);
        } else {
            this.logPageListener.setFirstPage(false);
            this.logPageListener.setLastPage(true);
        }
        return cmdStr;
    }

    protected synchronized String getFileSize(FileInfoBean fileInfo) {
        String fileName = fileInfo.getFileName();
        return "ls -l " + fileName + " | awk '{print $5}'";
    }
}

