/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.applications.impl;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.ChangeManager;
import com.intel.stl.api.management.DuplicateNameException;
import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.api.management.ReferenceConflictException;
import com.intel.stl.api.management.XMLUtils;
import com.intel.stl.api.management.applications.Application;
import com.intel.stl.api.management.applications.ApplicationException;
import com.intel.stl.api.management.applications.Applications;
import com.intel.stl.api.management.applications.IApplicationManagement;
import com.intel.stl.common.STLMessages;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationManagement
implements IApplicationManagement {
    private static final Logger log = LoggerFactory.getLogger(ApplicationManagement.class);
    private static final Set<String> RESERVED = new HashSet<String>(){
        private static final long serialVersionUID = -8507198541424973196L;
        {
            this.add("All");
            this.add("SA");
            this.add("PA");
            this.add("PM");
            this.add("AllOthers");
        }
    };
    private final FMConfHelper confHelp;
    private final ChangeManager changeMgr = new ChangeManager();

    public ApplicationManagement(FMConfHelper confHelp) {
        this.confHelp = confHelp;
    }

    @Override
    public Set<String> getReservedApplications() {
        return RESERVED;
    }

    @Override
    public synchronized List<Application> getApplications() throws ApplicationException {
        try {
            File confFile = this.confHelp.getConfFile();
            Applications apps = this.unmarshal(confFile);
            log.info("Fetch " + apps.getApplications().size() + " applications from host '" + this.confHelp.getHost() + "'");
            return apps.getApplications();
        }
        catch (Exception e) {
            throw this.createApplicationException(STLMessages.STL63001_GET_APPS_ERR, e, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    @Override
    public synchronized Application getApplication(String name) throws ApplicationException {
        try {
            File confFile = this.confHelp.getConfFile();
            Applications apps = this.unmarshal(confFile);
            return apps.getApplication(name);
        }
        catch (Exception e) {
            throw this.createApplicationException(STLMessages.STL63006_GET_APP_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected Applications unmarshal(File xmlFile) throws Exception {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        StreamSource xml = new StreamSource(xmlFile);
        XMLStreamReader xsr = xif.createXMLStreamReader(xml);
        while (!(!xsr.hasNext() || xsr.isStartElement() && xsr.getLocalName().equals("Applications"))) {
            xsr.next();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Applications.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        JAXBElement jb = unmarshaller.unmarshal(xsr, Applications.class);
        xsr.close();
        return (Applications)jb.getValue();
    }

    @Override
    public synchronized void addApplication(Application app) throws ApplicationException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.uniqueNameCheck(null, app.getName());
            this.addApplication(confFile, confFile, app);
            log.info("Added application " + app);
            this.changeMgr.addChange(app.getName());
        }
        catch (Exception e) {
            throw this.createApplicationException(STLMessages.STL63002_ADD_APP_ERR, e, app.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void addApplication(File srcXml, File dstXml, Application app) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{app.getClass()});
        context.createMarshaller().marshal((Object)app, (Result)res);
        Document appsDoc = (Document)res.getNode();
        Node newApp = appsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node appsNode = doc.getElementsByTagName("Applications").item(0);
        Node matchedApp = this.getApplicationByName(appsNode, app.getName());
        if (matchedApp != null) {
            throw new IllegalArgumentException("Application '" + app.getName() + "' alreday exist!");
        }
        XMLUtils.appendNode(doc, appsNode, newApp);
        XMLUtils.writeDoc(doc, dstXml);
    }

    @Override
    public synchronized void removeApplication(String name) throws ApplicationException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.referenceCheck(null, name);
            this.removeApplication(confFile, confFile, name);
            log.info("Removed application '" + name + "'");
            this.changeMgr.addChange(name);
        }
        catch (Exception e) {
            throw this.createApplicationException(STLMessages.STL63003_REMOVE_APP_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void removeApplication(File srcXml, File dstXml, String name) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node appsNode = doc.getElementsByTagName("Applications").item(0);
        Node matchedApp = this.getApplicationByName(appsNode, name);
        if (matchedApp != null) {
            XMLUtils.removeNode(doc, appsNode, matchedApp, name);
            XMLUtils.writeDoc(doc, dstXml);
        } else {
            log.warn("Couldn't find Application '" + name + "'");
        }
    }

    @Override
    public synchronized void updateApplication(String oldName, Application app) throws ApplicationException {
        try {
            File confFile = this.confHelp.getConfFile();
            if (!oldName.equals(app.getName())) {
                Applications apps = this.unmarshal(confFile);
                this.uniqueNameCheck(apps, app.getName());
                this.referenceCheck(apps, oldName);
            }
            this.updateApplication(confFile, confFile, oldName, app, false);
            log.info("Updated application " + app);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(app.getName());
        }
        catch (Exception e) {
            throw this.createApplicationException(STLMessages.STL63004_UPDATE_APP_ERR, e, app.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    @Override
    public synchronized void addOrUpdateApplication(String oldName, Application app) throws ApplicationException {
        try {
            File confFile = this.confHelp.getConfFile();
            if (!oldName.equals(app.getName())) {
                Applications apps = this.unmarshal(confFile);
                this.uniqueNameCheck(apps, app.getName());
                this.referenceCheck(apps, oldName);
            }
            this.updateApplication(confFile, confFile, oldName, app, true);
            log.info("Added or updated application " + app);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(app.getName());
        }
        catch (Exception e) {
            throw this.createApplicationException(STLMessages.STL63005_ADDUPDATE_APP_ERR, e, app.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateApplication(File srcXml, File dstXml, String oldName, Application app, boolean allowAdd) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{app.getClass()});
        context.createMarshaller().marshal((Object)app, (Result)res);
        Document appsDoc = (Document)res.getNode();
        Node newApp = appsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        doc.adoptNode(newApp);
        Node appsNode = doc.getElementsByTagName("Applications").item(0);
        Node matchedApp = this.getApplicationByName(appsNode, oldName);
        if (matchedApp == null) {
            if (!allowAdd) throw new IllegalArgumentException("Couldn't find Application '" + oldName + "'");
            XMLUtils.appendNode(doc, appsNode, newApp);
        } else {
            XMLUtils.replaceNode(doc, appsNode, matchedApp, newApp);
        }
        XMLUtils.writeDoc(doc, dstXml);
    }

    protected void referenceCheck(Applications apps, String name) throws Exception {
        List<Application> refs;
        if (apps == null) {
            File confFile = this.confHelp.getConfFile();
            apps = this.unmarshal(confFile);
        }
        if (!(refs = apps.getReferencedApplications(name)).isEmpty()) {
            String[] refNames = new String[refs.size()];
            for (int i = 0; i < refNames.length; ++i) {
                refNames[i] = refs.get(i).getName();
            }
            throw new ReferenceConflictException(name, refNames);
        }
    }

    protected void uniqueNameCheck(Applications apps, String name) throws Exception {
        if (apps == null) {
            File confFile = this.confHelp.getConfFile();
            apps = this.unmarshal(confFile);
        }
        for (Application app : apps.getApplications()) {
            if (!app.getName().equals(name)) continue;
            throw new DuplicateNameException(name);
        }
    }

    private Node getApplicationByName(Node appsNode, String name) {
        NodeList children = appsNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node nameNode;
            Node child = children.item(i);
            if (!child.getNodeName().equals("Application") || (nameNode = XMLUtils.getNodeByName(child, "Name")) == null || !nameNode.getTextContent().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected ApplicationException createApplicationException(IMessage msg, Throwable error, Object ... args) {
        return new ApplicationException(msg, error, args);
    }

    public boolean hasChanges() {
        return !this.changeMgr.getChanges().isEmpty();
    }

    public void applyChangesTo(ApplicationManagement target) throws ApplicationException {
        List<Application> apps = this.getApplications();
        HashMap<String, Application> map = new HashMap<String, Application>();
        for (Application app : apps) {
            map.put(app.getName(), app);
        }
        for (String change : this.changeMgr.getChanges()) {
            Application cur = (Application)map.get(change);
            if (cur == null) {
                target.removeApplication(change);
                continue;
            }
            target.addOrUpdateApplication(change, cur);
        }
        this.changeMgr.resetChanges();
    }

    public void reset() {
        this.changeMgr.resetChanges();
    }
}

