/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.devicegroups;

import com.intel.stl.api.management.NumberNode;
import com.intel.stl.api.management.devicegroups.DGSelect;
import com.intel.stl.api.management.devicegroups.DGSelectAdapter;
import com.intel.stl.api.management.devicegroups.IncludeGroup;
import com.intel.stl.api.management.devicegroups.NodeDesc;
import com.intel.stl.api.management.devicegroups.NodeGUID;
import com.intel.stl.api.management.devicegroups.NodeTypeAdapter;
import com.intel.stl.api.management.devicegroups.NodeTypeAttr;
import com.intel.stl.api.management.devicegroups.PortGUID;
import com.intel.stl.api.management.devicegroups.SystemImageGUID;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="DeviceGroup")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DeviceGroup {
    @XmlElement(name="Name")
    private String name;
    @XmlElements(value={@XmlElement(name="SystemImageGUID", type=SystemImageGUID.class), @XmlElement(name="NodeGUID", type=NodeGUID.class), @XmlElement(name="PortGUID", type=PortGUID.class)})
    private List<NumberNode> ids;
    @XmlElement(name="NodeDesc", type=NodeDesc.class)
    private List<NodeDesc> nodeDescs;
    @XmlElement(name="NodeType", type=String.class)
    @XmlJavaTypeAdapter(value=NodeTypeAdapter.class)
    private List<NodeTypeAttr> nodeTypes;
    @XmlElement(name="Select", type=String.class)
    @XmlJavaTypeAdapter(value=DGSelectAdapter.class)
    private List<DGSelect> selects;
    @XmlElement(name="IncludeGroup", type=IncludeGroup.class)
    private List<IncludeGroup> includeGroups;

    public DeviceGroup() {
    }

    public DeviceGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<NumberNode> getIDs() {
        return this.ids;
    }

    public void addID(NumberNode id) {
        if (id == null) {
            throw new IllegalArgumentException("null ID is not allowed.");
        }
        if (this.ids == null) {
            this.ids = new ArrayList<NumberNode>();
        }
        this.ids.add(id);
    }

    public List<NodeDesc> getNodeDesc() {
        return this.nodeDescs;
    }

    public void addNodeDesc(NodeDesc desc) {
        if (desc == null) {
            throw new IllegalArgumentException("null NodeDesc is not allowed.");
        }
        if (this.nodeDescs == null) {
            this.nodeDescs = new ArrayList<NodeDesc>();
        }
        this.nodeDescs.add(desc);
    }

    public List<NodeTypeAttr> getNodeTypes() {
        return this.nodeTypes;
    }

    public void addNodeType(NodeTypeAttr type) {
        if (type == null) {
            throw new IllegalArgumentException("null NodeType is not allowed.");
        }
        if (this.nodeTypes == null) {
            this.nodeTypes = new ArrayList<NodeTypeAttr>();
        }
        this.nodeTypes.add(type);
    }

    public List<DGSelect> getSelects() {
        return this.selects;
    }

    public void addSelect(DGSelect select) {
        if (select == null) {
            throw new IllegalArgumentException("null Select is not allowed.");
        }
        if (this.selects == null) {
            this.selects = new ArrayList<DGSelect>();
        }
        this.selects.add(select);
    }

    public List<IncludeGroup> getIncludeGroups() {
        return this.includeGroups;
    }

    public void addIncludeGroup(IncludeGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("null IncludeGroup is not allowed.");
        }
        if (group.getValue().equals(this.name)) {
            throw new IllegalArgumentException("Can not reference to itself.");
        }
        if (this.includeGroups == null) {
            this.includeGroups = new ArrayList<IncludeGroup>();
        }
        this.includeGroups.add(group);
    }

    public void addIncludeGroup(String group) {
        if (group == null) {
            throw new IllegalArgumentException("null IncludeGroup is not allowed.");
        }
        if (group.equals(this.name)) {
            throw new IllegalArgumentException("Can not reference to itself.");
        }
        if (this.includeGroups == null) {
            this.includeGroups = new ArrayList<IncludeGroup>();
        }
        this.includeGroups.add(new IncludeGroup(group));
    }

    public void removeIncludeGroup(String name) {
        if (this.includeGroups != null) {
            this.includeGroups.remove(new IncludeGroup(name));
        }
    }

    public void insertIncludeGroup(int index, String name) {
        if (this.includeGroups != null) {
            this.includeGroups.add(index, new IncludeGroup(name));
        }
    }

    public int indexOfIncludeGroup(String name) {
        IncludeGroup group = new IncludeGroup(name);
        if (this.includeGroups != null) {
            return this.includeGroups.indexOf(group);
        }
        return -1;
    }

    public boolean doesIncludeGroup(String name) {
        IncludeGroup group = new IncludeGroup(name);
        if (this.includeGroups != null) {
            return this.includeGroups.contains(group);
        }
        return false;
    }

    public void clear() {
        if (this.ids != null) {
            this.ids.clear();
        }
        if (this.nodeDescs != null) {
            this.nodeDescs.clear();
        }
        if (this.nodeTypes != null) {
            this.nodeTypes.clear();
        }
        if (this.selects != null) {
            this.selects.clear();
        }
        if (this.includeGroups != null) {
            this.includeGroups.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ids == null ? 0 : this.ids.hashCode());
        result = 31 * result + (this.includeGroups == null ? 0 : this.includeGroups.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodeDescs == null ? 0 : this.nodeDescs.hashCode());
        result = 31 * result + (this.nodeTypes == null ? 0 : this.nodeTypes.hashCode());
        result = 31 * result + (this.selects == null ? 0 : this.selects.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceGroup other = (DeviceGroup)obj;
        if (this.ids == null ? other.ids != null : !this.ids.equals(other.ids)) {
            return false;
        }
        if (this.includeGroups == null ? other.includeGroups != null : !this.includeGroups.equals(other.includeGroups)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nodeDescs == null ? other.nodeDescs != null : !this.nodeDescs.equals(other.nodeDescs)) {
            return false;
        }
        if (this.nodeTypes == null ? other.nodeTypes != null : !this.nodeTypes.equals(other.nodeTypes)) {
            return false;
        }
        return !(this.selects == null ? other.selects != null : !this.selects.equals(other.selects));
    }

    public DeviceGroup copy() {
        DeviceGroup res = new DeviceGroup(this.name);
        if (this.ids != null) {
            res.ids = new ArrayList<NumberNode>(this.ids.size());
            for (NumberNode id : this.ids) {
                res.ids.add(id.copy());
            }
        }
        if (this.nodeDescs != null) {
            res.nodeDescs = new ArrayList<NodeDesc>(this.nodeDescs.size());
            for (NodeDesc nd : this.nodeDescs) {
                res.nodeDescs.add(nd.copy());
            }
        }
        if (this.nodeTypes != null) {
            res.nodeTypes = new ArrayList<NodeTypeAttr>(this.nodeTypes);
        }
        if (this.selects != null) {
            res.selects = new ArrayList<DGSelect>(this.selects);
        }
        if (this.includeGroups != null) {
            res.includeGroups = new ArrayList<IncludeGroup>(this.includeGroups.size());
            for (IncludeGroup ig : this.includeGroups) {
                res.includeGroups.add(ig.copy());
            }
        }
        return res;
    }

    public String toString() {
        return "DeviceGroup [name=" + this.name + ", ids=" + this.ids + ", nodeDescs=" + this.nodeDescs + ", nodeTypes=" + this.nodeTypes + ", selects=" + this.selects + ", includeGroups=" + this.includeGroups + "]";
    }
}

