/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.devicegroups.impl;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.ChangeManager;
import com.intel.stl.api.management.DuplicateNameException;
import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.api.management.ReferenceConflictException;
import com.intel.stl.api.management.XMLUtils;
import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.api.management.devicegroups.DeviceGroupException;
import com.intel.stl.api.management.devicegroups.DeviceGroups;
import com.intel.stl.api.management.devicegroups.IDeviceGroupManagement;
import com.intel.stl.common.STLMessages;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceGroupManagement
implements IDeviceGroupManagement {
    private static final Logger log = LoggerFactory.getLogger(DeviceGroupManagement.class);
    private static final Set<String> RESERVED = new HashSet<String>(){
        private static final long serialVersionUID = -8507198541424973196L;
        {
            this.add("All");
            this.add("AllFIs");
            this.add("AllSWs");
            this.add("AllSWE0s");
            this.add("AllEndNodes");
            this.add("AllSMs");
            this.add("AllMgmtAllowed");
            this.add("HFIDirectConnect");
            this.add("Self");
        }
    };
    private final FMConfHelper confHelp;
    private final ChangeManager changeMgr = new ChangeManager();

    public DeviceGroupManagement(FMConfHelper confHelp) {
        this.confHelp = confHelp;
    }

    @Override
    public Set<String> getReservedDeviceGroups() {
        return RESERVED;
    }

    @Override
    public synchronized List<DeviceGroup> getDeviceGroups() throws DeviceGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            DeviceGroups groups = this.unmarshal(confFile);
            log.info("Fetch " + groups.getGroups().size() + " Device Groups from host '" + this.confHelp.getHost() + "'");
            return groups.getGroups();
        }
        catch (Exception e) {
            throw this.createDeviceGroupException(STLMessages.STL63011_GET_DGS_ERR, e, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    @Override
    public synchronized DeviceGroup getDeviceGroup(String name) throws DeviceGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            DeviceGroups groups = this.unmarshal(confFile);
            return groups.getGroup(name);
        }
        catch (Exception e) {
            throw this.createDeviceGroupException(STLMessages.STL63016_GET_DG_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    private DeviceGroups unmarshal(File xmlFile) throws Exception {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        StreamSource xml = new StreamSource(xmlFile);
        XMLStreamReader xsr = xif.createXMLStreamReader(xml);
        while (!(!xsr.hasNext() || xsr.isStartElement() && xsr.getLocalName().equals("DeviceGroups"))) {
            xsr.next();
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DeviceGroups.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        JAXBElement jb = unmarshaller.unmarshal(xsr, DeviceGroups.class);
        xsr.close();
        return (DeviceGroups)jb.getValue();
    }

    @Override
    public synchronized void addDeviceGroup(DeviceGroup group) throws DeviceGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.uniqueNameCheck(null, group.getName());
            this.addDeviceGroup(confFile, confFile, group);
            log.info("Added application " + group);
            this.changeMgr.addChange(group.getName());
        }
        catch (Exception e) {
            throw this.createDeviceGroupException(STLMessages.STL63012_ADD_DG_ERR, e, group.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void addDeviceGroup(File srcXml, File dstXml, DeviceGroup group) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{group.getClass()});
        context.createMarshaller().marshal((Object)group, (Result)res);
        Document groupsDoc = (Document)res.getNode();
        Node newGroup = groupsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node groupsNode = doc.getElementsByTagName("DeviceGroups").item(0);
        Node matchedGroup = this.getGroupByName(groupsNode, group.getName());
        if (matchedGroup != null) {
            throw new IllegalArgumentException("Device Group '" + group.getName() + "' alreday exist!");
        }
        XMLUtils.appendNode(doc, groupsNode, newGroup);
        XMLUtils.writeDoc(doc, dstXml);
    }

    @Override
    public synchronized void removeDeviceGroup(String name) throws DeviceGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.referenceCheck(null, name);
            this.removeDeviceGroup(confFile, confFile, name);
            log.info("Removed application '" + name + "'");
            this.changeMgr.addChange(name);
        }
        catch (Exception e) {
            throw this.createDeviceGroupException(STLMessages.STL63013_REMOVE_DG_ERR, e, name, this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    protected void removeDeviceGroup(File srcXml, File dstXml, String name) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        Node groupsNode = doc.getElementsByTagName("DeviceGroups").item(0);
        Node matchedGroup = this.getGroupByName(groupsNode, name);
        if (matchedGroup != null) {
            XMLUtils.removeNode(doc, groupsNode, matchedGroup, name);
            XMLUtils.writeDoc(doc, dstXml);
        } else {
            log.warn("Couldn't find Device Group '" + name + "'");
        }
    }

    @Override
    public synchronized void updateDeviceGroup(String oldName, DeviceGroup group) throws DeviceGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            if (!oldName.equals(group.getName())) {
                DeviceGroups groups = this.unmarshal(confFile);
                this.uniqueNameCheck(groups, group.getName());
                this.referenceCheck(groups, oldName);
            }
            this.updateDeviceGroup(confFile, confFile, oldName, group, false);
            log.info("Updated Device Group " + group);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(group.getName());
        }
        catch (Exception e) {
            throw this.createDeviceGroupException(STLMessages.STL63014_UPDATE_DG_ERR, e, group.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    @Override
    public synchronized void addOrUpdateDeviceGroup(String oldName, DeviceGroup group) throws DeviceGroupException {
        try {
            File confFile = this.confHelp.getConfFile();
            this.referenceCheck(null, oldName);
            this.updateDeviceGroup(confFile, confFile, oldName, group, true);
            log.info("Added or updated Device Group " + group);
            this.changeMgr.addChange(oldName);
            this.changeMgr.addChange(group.getName());
        }
        catch (Exception e) {
            throw this.createDeviceGroupException(STLMessages.STL63015_ADDUPDATE_DG_ERR, e, group.getName(), this.confHelp.getHost(), StringUtils.getErrorMessage(e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateDeviceGroup(File srcXml, File dstXml, String oldName, DeviceGroup group, boolean allowAdd) throws Exception {
        DOMResult res = new DOMResult();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{group.getClass()});
        context.createMarshaller().marshal((Object)group, (Result)res);
        Document groupsDoc = (Document)res.getNode();
        Node newGroup = groupsDoc.getFirstChild();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(srcXml);
        doc.adoptNode(newGroup);
        Node groupsNode = doc.getElementsByTagName("DeviceGroups").item(0);
        Node matchedGroup = this.getGroupByName(groupsNode, oldName);
        if (matchedGroup == null) {
            if (!allowAdd) throw new IllegalArgumentException("Couldn't find Device Gruop '" + oldName + "'");
            XMLUtils.appendNode(doc, groupsNode, newGroup);
        } else {
            XMLUtils.replaceNode(doc, groupsNode, matchedGroup, newGroup);
        }
        XMLUtils.writeDoc(doc, dstXml);
    }

    protected void referenceCheck(DeviceGroups groups, String name) throws Exception {
        List<DeviceGroup> refs;
        if (groups == null) {
            File confFile = this.confHelp.getConfFile();
            groups = this.unmarshal(confFile);
        }
        if (!(refs = groups.getReferencedGroups(name)).isEmpty()) {
            String[] refNames = new String[refs.size()];
            for (int i = 0; i < refNames.length; ++i) {
                refNames[i] = refs.get(i).getName();
            }
            throw new ReferenceConflictException(name, refNames);
        }
    }

    protected void uniqueNameCheck(DeviceGroups groups, String name) throws Exception {
        if (groups == null) {
            File confFile = this.confHelp.getConfFile();
            groups = this.unmarshal(confFile);
        }
        for (DeviceGroup group : groups.getGroups()) {
            if (!group.getName().equals(name)) continue;
            throw new DuplicateNameException(name);
        }
    }

    private Node getGroupByName(Node appsNode, String name) {
        NodeList children = appsNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node nameNode;
            Node child = children.item(i);
            if (!child.getNodeName().equals("DeviceGroup") || (nameNode = XMLUtils.getNodeByName(child, "Name")) == null || !nameNode.getTextContent().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected DeviceGroupException createDeviceGroupException(IMessage msg, Throwable error, Object ... args) {
        return new DeviceGroupException(msg, error, args);
    }

    public boolean hasChanges() {
        return !this.changeMgr.getChanges().isEmpty();
    }

    public void applyChangesTo(DeviceGroupManagement target) throws DeviceGroupException {
        List<DeviceGroup> groups = this.getDeviceGroups();
        HashMap<String, DeviceGroup> map = new HashMap<String, DeviceGroup>();
        for (DeviceGroup group : groups) {
            map.put(group.getName(), group);
        }
        for (String change : this.changeMgr.getChanges()) {
            DeviceGroup cur = (DeviceGroup)map.get(change);
            if (cur == null) {
                target.removeDeviceGroup(change);
                continue;
            }
            target.addOrUpdateDeviceGroup(change, cur);
        }
        this.changeMgr.resetChanges();
    }

    public void reset() {
        this.changeMgr.resetChanges();
    }
}

