/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.virtualfabrics;

import com.intel.stl.api.management.WrapperNode;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;

public class HoqLife
extends WrapperNode<TimeOut> {
    private static final long serialVersionUID = -3442071697440514266L;

    public HoqLife() {
        this(null);
    }

    public HoqLife(TimeOut value) {
        super("HoqLife", value);
    }

    @Override
    protected TimeOut valueOf(String str) {
        int pos;
        str = str.trim();
        for (pos = 0; pos < str.length() && Character.isDigit(str.charAt(pos)); ++pos) {
        }
        if (pos < str.length() - 1) {
            String numStr = str.substring(0, pos);
            String unitStr = str.substring(pos).trim();
            TimeOut.Unit unit = TimeOut.Unit.valueOf(unitStr.toUpperCase());
            if (unit != null) {
                int num = Integer.parseInt(numStr);
                return new TimeOut(num, unit);
            }
        }
        throw new IllegalArgumentException("Invalid format '" + str + "'");
    }

    @Override
    protected String valueString(TimeOut value) {
        return value.toString();
    }

    @Override
    public HoqLife copy() {
        return new HoqLife((TimeOut)this.value);
    }

    public String toString() {
        return "HoqLife [type=" + this.type + ", value=" + this.value + "]";
    }

    @Override
    public void installVirtualFabric(VirtualFabric vf) {
        vf.setHoqLife(this);
    }

    public static class TimeOut {
        private final int value;
        private final Unit unit;

        public TimeOut(int value, Unit unit) {
            this.value = value;
            this.unit = unit;
        }

        public int getValue() {
            return this.value;
        }

        public Unit getUnit() {
            return this.unit;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeOut other = (TimeOut)obj;
            if (this.unit == null ? other.unit != null : !this.unit.equals((Object)other.unit)) {
                return false;
            }
            return this.value == other.value;
        }

        public String toString() {
            return this.value + this.unit.name().toLowerCase();
        }

        public static enum Unit {
            NS,
            US,
            MS,
            S,
            M,
            H;

        }
    }
}

