/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.notice;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NoticeType {
    FATAL(0),
    URGENT(1),
    SECURITY(2),
    SM(3),
    INFO(4),
    EMPTY(127);

    private static Logger log;
    private final byte id;

    private NoticeType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static NoticeType getNoticeType(byte id) {
        for (NoticeType type : NoticeType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        log.warn("Unknown NoticeType id " + id);
        return null;
    }

    static {
        log = LoggerFactory.getLogger(NoticeType.class);
    }
}

