/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.notice.impl;

import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.IEventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class EventDispatcher
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    private final Object mutex = new Object();
    private boolean stop = false;
    private final List<EventDescription> events = new ArrayList<EventDescription>();
    private final List<IEventListener<EventDescription>> eventListeners = new CopyOnWriteArrayList<IEventListener<EventDescription>>();
    private Map<String, String> loggingContextMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(List<EventDescription> newEvents) {
        Object object;
        if (newEvents == null || newEvents.isEmpty()) {
            return;
        }
        try {
            object = this.events;
            synchronized (object) {
                this.events.addAll(newEvents);
            }
        }
        finally {
            object = this.mutex;
            synchronized (object) {
                this.mutex.notify();
            }
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public void addEventListener(IEventListener<EventDescription> listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(IEventListener<EventDescription> listener) {
        this.eventListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.stop = true;
        this.eventListeners.clear();
        Object object = this.events;
        synchronized (object) {
            this.events.clear();
        }
        object = this.mutex;
        synchronized (object) {
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.loggingContextMap != null) {
            MDC.setContextMap(this.loggingContextMap);
        }
        log.info("Notice EventDispather '" + this.getName() + "' started");
        this.stop = false;
        while (!this.stop) {
            EventDescription[] toProcess = null;
            Object object = this.events;
            synchronized (object) {
                toProcess = this.events.toArray(new EventDescription[0]);
                this.events.clear();
            }
            if (toProcess != null && toProcess.length > 0) {
                for (EventDescription event : toProcess) {
                    log.info("Notify event: " + event);
                }
                for (IEventListener<EventDescription> listener : this.eventListeners) {
                    listener.onNewEvent((EventDescription[])toProcess);
                }
                continue;
            }
            object = this.mutex;
            synchronized (object) {
                try {
                    if (!this.stop) {
                        this.mutex.wait();
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Notice EventDispatcher interrupted!");
                }
            }
        }
        log.info("Notice EventDispather '" + this.getName() + "' stopped");
    }

    public void setLoggingContextMap(Map<String, String> loggingContextMap) {
        this.loggingContextMap = loggingContextMap;
    }
}

