/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.notice.impl;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.configuration.impl.SubnetContextImpl;
import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.FESource;
import com.intel.stl.api.notice.GenericNoticeAttrBean;
import com.intel.stl.api.notice.IEventListener;
import com.intel.stl.api.notice.IEventSource;
import com.intel.stl.api.notice.INoticeApi;
import com.intel.stl.api.notice.NodeSource;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.notice.NoticeWrapper;
import com.intel.stl.api.notice.PortSource;
import com.intel.stl.api.notice.TrapLinkBean;
import com.intel.stl.api.notice.TrapSwitchPKeyBean;
import com.intel.stl.api.notice.TrapSysguidBean;
import com.intel.stl.api.notice.TrapType;
import com.intel.stl.api.notice.impl.EventDispatcher;
import com.intel.stl.api.subnet.GIDBean;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetException;
import com.intel.stl.api.subnet.impl.NodeCache;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.fecdriver.messages.adapter.sa.trap.TrapDetail;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.MDC;

public class NoticeApi
implements INoticeApi {
    private static final String THREAD_NAME_PREFIX = "nedthread-";
    private static boolean DEBUG = false;
    private final SubnetContextImpl subnetContext;
    private final CacheManager cacheMgr;
    private final EventDispatcher worker;
    private final Map<EventType, NoticeSeverity> eventSeverityMap = new HashMap<EventType, NoticeSeverity>();

    public NoticeApi(SubnetContextImpl subnetContext) {
        this.worker = new EventDispatcher();
        this.subnetContext = subnetContext;
        this.cacheMgr = subnetContext.getCacheManager();
        this.startWorker();
    }

    protected void startWorker() {
        MDC.put((String)"subnet", (String)this.subnetContext.getSubnetDescription().getName());
        this.worker.setLoggingContextMap(MDC.getCopyOfContextMap());
        this.worker.setDaemon(true);
        this.worker.setName(THREAD_NAME_PREFIX + this.subnetContext.getSubnetDescription().getSubnetId());
        this.worker.start();
    }

    @Override
    public void addNewEventDescriptions(NoticeWrapper[] data) {
        if (DEBUG) {
            for (NoticeWrapper bean : data) {
                System.out.println(bean);
            }
        }
        ArrayList<EventDescription> events = new ArrayList<EventDescription>();
        for (NoticeWrapper nw : data) {
            EventDescription eventDescription = this.asEventDescription(nw);
            events.add(eventDescription);
        }
        this.worker.addEvents(events);
    }

    @Override
    public void addEventListener(IEventListener<EventDescription> listener) {
        this.worker.addEventListener(listener);
    }

    @Override
    public void removeEventListener(IEventListener<EventDescription> listener) {
        this.worker.removeEventListener(listener);
    }

    @Override
    public void cleanup() {
        this.worker.cleanup();
        this.worker.setStop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventDescription asEventDescription(NoticeWrapper noticeWrapper) {
        NoticeBean bean = noticeWrapper.getNotice();
        EventDescription res = new EventDescription();
        res.setId(bean.getId());
        res.setDate(new Date(bean.getReceiveTimestamp()));
        res.setRelatedNodes(noticeWrapper.getRelatedNodes());
        GenericNoticeAttrBean attr = (GenericNoticeAttrBean)bean.getAttributes();
        TrapType trap = TrapType.getTrapType(attr.getTrapNumber());
        IEventSource source = null;
        try {
            EventType eventType = EventType.getEventType(trap);
            res.setType(eventType);
            res.setSeverity(this.eventSeverityMap.get((Object)eventType));
            switch (trap) {
                case SM_CONNECTION_LOST: 
                case SM_CONNECTION_ESTABLISH: {
                    source = this.getSMSource(bean);
                    break;
                }
                case FE_CONNECTION_LOST: 
                case FE_CONNECTION_ESTABLISH: {
                    source = this.getFESource(bean);
                    break;
                }
                case GID_NOW_IN_SERVICE: 
                case GID_OUT_OF_SERVICE: 
                case ADD_MULTICAST_GROUP: 
                case DEL_MULTICAST_GROUP: {
                    source = this.getEndPortSource(bean);
                    break;
                }
                case LINK_INTEGRITY: 
                case BUFFER_OVERRUN: 
                case FLOW_WATCHDOG: {
                    source = this.getPortSource(bean);
                    break;
                }
                case LINK_PORT_CHANGE_STATE: 
                case CHANGE_CAPABILITY: 
                case BAD_M_KEY: 
                case SMA_TRAP_LINK_WIDTH: 
                case BAD_P_KEY: 
                case BAD_Q_KEY: {
                    int lid = TrapDetail.getLid(bean.getData());
                    source = this.getNodeSource(lid);
                    break;
                }
                case SWITCH_BAD_PKEY: {
                    TrapSwitchPKeyBean key = TrapDetail.getTrapSwitchPKey(bean.getData());
                    source = this.getNodeSource(key.getLid1());
                    break;
                }
                case CHANGE_SYSGUID: {
                    TrapSysguidBean sysguid = TrapDetail.getTrapSysguid(bean.getData());
                    source = this.getNodeSource(sysguid.getLid());
                    break;
                }
                default: {
                    source = this.getNodeSource(0);
                }
            }
            res.setSource(source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            res.setSource(source);
        }
        return res;
    }

    protected NodeSource getSMSource(NoticeBean bean) throws Exception {
        int lid = bean.getIssuerLID();
        NodeRecordBean node = null;
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        node = nodeCache.getNode(lid);
        NodeType type = node.getNodeType();
        return new NodeSource(lid, node.getNodeDesc(), type);
    }

    protected NodeSource getNodeSource(int lid) throws Exception {
        NodeRecordBean node = null;
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        node = nodeCache.getNode(lid);
        NodeType type = node.getNodeType();
        return new NodeSource(lid, node.getNodeDesc(), type);
    }

    protected FESource getFESource(NoticeBean bean) {
        HostInfo hi = this.subnetContext.getSubnetDescription().getCurrentFE();
        return new FESource(hi.getHost(), hi.getPort());
    }

    protected PortSource getEndPortSource(NoticeBean bean) {
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        GIDBean gid = TrapDetail.getGID(bean.getData());
        NodeRecordBean node = null;
        try {
            node = nodeCache.getNode(gid.getInterfaceID());
            NodeType type = node.getNodeType();
            return new PortSource(node.getLid(), node.getNodeDesc(), type, node.getNodeInfo().getLocalPortNum());
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid GID " + gid);
            iae.initCause(e);
            throw iae;
        }
    }

    protected PortSource getPortSource(NoticeBean bean) throws SubnetException, SubnetDataNotFoundException {
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        TrapLinkBean link = TrapDetail.getTrapLink(bean.getData());
        NodeRecordBean node = null;
        node = nodeCache.getNode(link.getLid());
        NodeType type = NodeType.getNodeType(node.getNodeInfo().getNodeType());
        return new PortSource(link.getLid(), node.getNodeDesc(), type, link.getPort());
    }

    @Override
    public void setUserSettings(UserSettings userSettings) {
        List<EventRule> eventRules = userSettings.getEventRules();
        if (eventRules != null) {
            for (EventRule er : eventRules) {
                this.eventSeverityMap.put(er.getEventType(), er.getEventSeverity());
            }
        }
    }
}

