/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import com.intel.stl.api.Utils;
import com.intel.stl.api.configuration.PortState;
import com.intel.stl.api.subnet.PortDownReasonBean;
import com.intel.stl.api.subnet.PortInfoBean;
import java.io.Serializable;
import java.util.Arrays;

public class PortRecordBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NaN = -1;
    private int endPortLID = -1;
    private short portNum = (short)-1;
    private PortInfoBean portInfo = null;
    private PortDownReasonBean[] linkDownReasons;

    public PortRecordBean() {
    }

    public PortRecordBean(int endPortLID, byte portNum, PortInfoBean portInfo) {
        this.endPortLID = endPortLID;
        this.portNum = Utils.unsignedByte(portNum);
        this.portInfo = portInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endPortLID;
        result = 31 * result + this.portNum;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortRecordBean other = (PortRecordBean)obj;
        if (this.endPortLID != other.endPortLID) {
            return false;
        }
        return this.portNum == other.portNum;
    }

    public int getEndPortLID() {
        return this.endPortLID;
    }

    public void setEndPortLID(int endPortLID) {
        this.endPortLID = endPortLID;
    }

    public short getPortNum() {
        return this.portNum;
    }

    public void setPortNum(short portNum) {
        this.portNum = portNum;
    }

    public void setPortNum(byte portNum) {
        this.portNum = Utils.unsignedByte(portNum);
    }

    public PortInfoBean getPortInfo() {
        return this.portInfo;
    }

    public void setPortInfo(PortInfoBean portInfo) {
        this.portInfo = portInfo;
    }

    public PortDownReasonBean[] getLinkDownReasons() {
        return this.linkDownReasons;
    }

    public void setLinkDownReasons(PortDownReasonBean[] linkDownReasons) {
        this.linkDownReasons = linkDownReasons;
    }

    public boolean isActive() {
        if (this.portInfo == null || this.portInfo.getPortStates() == null || this.portInfo.getPortStates().getPortState() == null) {
            return false;
        }
        return this.portInfo.getPortStates().getPortState() == PortState.ACTIVE;
    }

    public String toString() {
        return "PortRecordBean [endPortLID=" + this.endPortLID + ", portNum=" + this.portNum + ", portInfo=" + this.portInfo + ", linkDownReasons=" + Arrays.toString(this.linkDownReasons) + "]";
    }
}

