/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import com.intel.stl.api.IConnectionAssistant;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SMRecordBean;
import com.intel.stl.api.subnet.SshLoginBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class SubnetDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long subnetId;
    private String name;
    private int primaryFEIndex;
    private int currentFEIndex;
    private List<HostInfo> feList;
    private String currentUser;
    private boolean autoConnect;
    private boolean topologyUpdated;
    private AtomicBoolean failoverInProgress = new AtomicBoolean(false);
    private IConnectionAssistant connectionAssistant;
    private List<SMRecordBean> smList;
    private Status lastStatus = Status.UNKNOWN;
    private long statusTimestamp;

    public SubnetDescription() {
    }

    public SubnetDescription(String name) {
        this.name = name;
    }

    public SubnetDescription(String name, String host, int port) {
        this.name = name;
        HostInfo hostInfo = new HostInfo(host, port);
        this.getFEList().add(hostInfo);
    }

    public SubnetDescription(SshLoginBean loginBean) {
        this(loginBean.getSubnetName(), loginBean.getHost(), loginBean.getPort());
        this.subnetId = loginBean.getId();
        this.getCurrentFE().setSshUserName(loginBean.getSshUserName());
    }

    public long getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(long subnetId) {
        this.subnetId = subnetId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getPrimaryFEIndex() {
        return this.primaryFEIndex;
    }

    public void setPrimaryFEIndex(int primary) {
        this.checkIndex(primary);
        this.primaryFEIndex = primary;
    }

    public int getCurrentFEIndex() {
        return this.currentFEIndex;
    }

    public void setCurrentFEIndex(int current) {
        this.checkIndex(current);
        this.currentFEIndex = current;
    }

    public void setFEList(List<HostInfo> feList) {
        this.feList = feList;
    }

    public List<HostInfo> getFEList() {
        if (this.feList == null) {
            this.feList = new ArrayList<HostInfo>();
        }
        return this.feList;
    }

    public void setSMList(List<SMRecordBean> smList) {
        this.smList = smList;
    }

    public List<SMRecordBean> getSMList() {
        return this.smList;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public Status getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(Status lastStatus) {
        this.lastStatus = lastStatus;
        this.statusTimestamp = System.currentTimeMillis();
    }

    public void setStatusTimestamp(long statusTimestamp) {
        this.statusTimestamp = statusTimestamp;
    }

    public long getStatusTimestamp() {
        return this.statusTimestamp;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
    }

    public boolean isTopologyUpdated() {
        return this.topologyUpdated;
    }

    public void setTopologyUpdated(boolean topologyUpdated) {
        this.topologyUpdated = topologyUpdated;
    }

    public boolean isFailoverInProgress() {
        return this.failoverInProgress.get();
    }

    public boolean setFailoverInProgress(boolean expected, boolean failoverInProgress) {
        return this.failoverInProgress.compareAndSet(expected, failoverInProgress);
    }

    public HostInfo getPrimaryFE() {
        return this.getHostInfo(this.primaryFEIndex);
    }

    public HostInfo getCurrentFE() {
        return this.getHostInfo(this.currentFEIndex);
    }

    private HostInfo getHostInfo(int index) {
        if (this.feList == null) {
            throw new IllegalArgumentException("No list of FEs");
        }
        this.checkIndex(index);
        return this.feList.get(index);
    }

    public IConnectionAssistant getConnectionAssistant() {
        return this.connectionAssistant;
    }

    public void setConnectionAssistant(IConnectionAssistant connectionAssistant) {
        this.connectionAssistant = connectionAssistant;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.feList.size()) {
            throw new IllegalArgumentException("Invalid index '" + index + "' for list of FEs (" + this.feList.size() + ")");
        }
    }

    public SubnetDescription copy() {
        SubnetDescription subnet = new SubnetDescription();
        subnet.subnetId = this.subnetId;
        subnet.name = this.name;
        if (this.feList != null) {
            ArrayList<HostInfo> newFeList = new ArrayList<HostInfo>(this.feList);
            subnet.setFEList(newFeList);
        } else {
            subnet.setFEList(null);
        }
        subnet.primaryFEIndex = this.primaryFEIndex;
        subnet.currentFEIndex = this.currentFEIndex;
        subnet.lastStatus = this.lastStatus;
        subnet.statusTimestamp = this.statusTimestamp;
        subnet.topologyUpdated = this.topologyUpdated;
        subnet.failoverInProgress = this.failoverInProgress;
        subnet.connectionAssistant = this.connectionAssistant;
        return subnet;
    }

    public void setContent(SubnetDescription subnet) {
        if (!this.name.equals(subnet.name)) {
            throw new IllegalArgumentException("Can not set content of another subnet");
        }
        this.primaryFEIndex = subnet.primaryFEIndex;
        this.currentFEIndex = subnet.currentFEIndex;
        this.autoConnect = subnet.autoConnect;
        this.lastStatus = subnet.lastStatus;
        this.feList = subnet.feList;
        this.currentUser = subnet.currentUser;
        this.failoverInProgress = subnet.failoverInProgress;
        this.connectionAssistant = subnet.connectionAssistant;
    }

    public String toString() {
        return "SubnetDescription [id=" + this.subnetId + ", name=" + this.name + ", currentFEIndex=" + this.currentFEIndex + ", list FEs=" + this.feList + ", autoConnect=" + this.autoConnect + ", topologyUpdated=" + this.topologyUpdated + ", lastStatus=" + (Object)((Object)this.lastStatus) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.subnetId ^ this.subnetId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubnetDescription other = (SubnetDescription)obj;
        return this.subnetId == other.subnetId;
    }

    public static enum Status {
        UNKNOWN,
        VALID,
        INVALID;

    }
}

