/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.CableRecordBean;
import com.intel.stl.api.subnet.impl.CableCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CableCacheImpl
extends MemoryCache<Map<Integer, List<CableRecordBean>>>
implements CableCache {
    private final SAHelper helper;

    public CableCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<CableRecordBean> getCables() {
        Map map = (Map)this.getCachedObject();
        List<CableRecordBean> res = new ArrayList<CableRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (List cables : map.values()) {
                for (CableRecordBean cable : cables) {
                    res.add(cable);
                }
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getCables();
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public List<CableRecordBean> getCable(int lid) {
        Map map = (Map)this.getCachedObject();
        List<Object> res = new ArrayList();
        if (map != null) {
            res = (List)map.get(lid);
        }
        if (res != null && !res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getCables(lid);
            if (res != null && !res.isEmpty()) {
                this.setCacheReady(false);
            }
        }
        catch (Exception e) {
            log.error("Error getting Cable Infos by lid " + lid, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    public List<CableRecordBean> getCable(int lid, short portNum) {
        List cables;
        Map map = (Map)this.getCachedObject();
        ArrayList<CableRecordBean> res = new ArrayList<CableRecordBean>();
        if (map != null && (cables = (List)map.get(lid)) != null) {
            for (CableRecordBean cable : cables) {
                if (cable.getLid() != lid || cable.getPort() != portNum) continue;
                res.add(cable);
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            List<CableRecordBean> cablesFromFE = this.helper.getCables(lid);
            if (cablesFromFE != null && !cablesFromFE.isEmpty()) {
                this.setCacheReady(false);
                for (CableRecordBean cable : cablesFromFE) {
                    if (cable.getLid() != lid || cable.getPort() != portNum) continue;
                    res.add(cable);
                }
            }
        }
        catch (Exception e) {
            log.error("Error getting Cable Infos by lid " + lid + ", portNum=" + portNum, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    protected Map<Integer, List<CableRecordBean>> retrieveObjectForCache() throws Exception {
        List<CableRecordBean> cables = this.helper.getCables();
        log.info("Retrieve " + (cables == null ? 0 : cables.size()) + " Cable Infos from FE");
        HashMap map = null;
        if (cables != null) {
            map = new HashMap();
            for (CableRecordBean cable : cables) {
                int lid = cable.getLid();
                if (map.containsKey(lid)) {
                    ((List)map.get(lid)).add(cable);
                    continue;
                }
                ArrayList<CableRecordBean> list = new ArrayList<CableRecordBean>();
                list.add(cable);
                map.put(cable.getLid(), list);
            }
        }
        return map;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map map = (Map)this.getCachedObject();
        if (map != null && !map.isEmpty()) {
            map.remove(notice.getLid());
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

