/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.configuration.PortState;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.impl.LinkCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LinkCacheImpl
extends MemoryCache<List<LinkRecordBean>>
implements LinkCache {
    private final SAHelper helper;

    public LinkCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<LinkRecordBean> getLinks(boolean includeInactive) throws SubnetDataNotFoundException {
        ArrayList<LinkRecordBean> res = new ArrayList<LinkRecordBean>();
        List links = (List)this.getCachedObject();
        if (links != null && !links.isEmpty()) {
            for (LinkRecordBean link : links) {
                if (!includeInactive && !link.isActive()) continue;
                res.add(link);
            }
        }
        if (!res.isEmpty()) {
            return Collections.unmodifiableList(res);
        }
        throw new SubnetDataNotFoundException(STLMessages.STL30058_LINK_NOT_FOUND_CACHE_ALL);
    }

    @Override
    public LinkRecordBean getLinkBySource(int lid, short portNum) throws SubnetDataNotFoundException {
        List<LinkRecordBean> links = this.getLinks(true);
        for (LinkRecordBean link : links) {
            if (link.getFromLID() != lid || link.getFromPortIndex() != portNum) continue;
            return link;
        }
        try {
            links = this.helper.getLinks(lid);
            if (links != null && !links.isEmpty()) {
                this.setCacheReady(false);
                for (LinkRecordBean link : links) {
                    if (link.getFromPortIndex() != portNum) continue;
                    return link;
                }
            }
        }
        catch (Exception e) {
            log.error("Error getting link by source lid=" + lid + ", portNum=" + portNum + " from Fabric", (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        throw new SubnetDataNotFoundException(STLMessages.STL30058_LINK_NOT_FOUND_CACHE_ALL);
    }

    @Override
    public LinkRecordBean getLinkByDestination(int lid, short portNum) throws SubnetDataNotFoundException {
        List<LinkRecordBean> links = this.getLinks(true);
        for (LinkRecordBean link : links) {
            if (link.getToLID() != lid || link.getToPortIndex() != portNum) continue;
            return link;
        }
        try {
            links = this.helper.getLinks(lid);
            if (links != null && !links.isEmpty()) {
                for (LinkRecordBean link : links) {
                    if (link.getFromPortIndex() != portNum) continue;
                    this.setCacheReady(false);
                    return new LinkRecordBean(link.getToLID(), link.getToPortIndex(), link.getFromLID(), link.getFromPortIndex());
                }
            }
        }
        catch (Exception e) {
            log.error("Error getting link by destination lid=" + lid + ", portNum=" + portNum + " from Fabric", (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        throw new SubnetDataNotFoundException(STLMessages.STL30058_LINK_NOT_FOUND_CACHE_ALL);
    }

    @Override
    protected List<LinkRecordBean> retrieveObjectForCache() throws Exception {
        List<LinkRecordBean> res = this.helper.getLinks();
        log.info("Retrieve " + (res == null ? 0 : res.size()) + " links from FE");
        return res;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        List links = (List)this.getCachedObject();
        if (links == null) {
            log.info("No links from FM");
            return false;
        }
        switch (notice.getTrapType()) {
            case GID_NOW_IN_SERVICE: {
                this.resetLinks(notice, true);
                break;
            }
            case GID_OUT_OF_SERVICE: {
                this.resetLinks(notice, false);
                break;
            }
            case LINK_PORT_CHANGE_STATE: {
                HashMap<Short, PortState> portMap = new HashMap<Short, PortState>();
                for (PortRecordBean port : notice.getPorts()) {
                    PortState portState = port.getPortInfo().getPortStates().getPortState();
                    portMap.put(port.getPortNum(), portState);
                }
                this.resetLinksUsingPortMap(notice, portMap);
                break;
            }
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }

    private void resetLinks(NoticeProcess notice, boolean status) {
        block4: {
            List<LinkRecordBean> newLinks;
            int lid;
            List links;
            block3: {
                links = (List)this.getCachedObject();
                lid = notice.getLid();
                newLinks = notice.getLinks();
                if (newLinks != null) break block3;
                for (LinkRecordBean link : links) {
                    if (link.getFromLID() != lid && link.getToLID() != lid) continue;
                    link.setActive(false);
                }
                break block4;
            }
            ArrayList<LinkRecordBean> rwNewLinks = new ArrayList<LinkRecordBean>(newLinks);
            for (LinkRecordBean link : links) {
                if (link.getFromLID() != lid && link.getToLID() != lid) continue;
                this.processLink(link, status, rwNewLinks);
            }
            if (rwNewLinks.size() <= 0) break block4;
            for (LinkRecordBean newLink : rwNewLinks) {
                newLink.setActive(status);
                links.add(newLink);
            }
        }
    }

    private void processLink(LinkRecordBean memLink, boolean status, List<LinkRecordBean> newLinks) {
        Iterator<LinkRecordBean> it = newLinks.iterator();
        boolean found = false;
        while (it.hasNext()) {
            LinkRecordBean newLink = it.next();
            if (memLink.getFromLID() != newLink.getFromLID() || memLink.getFromPortIndex() != newLink.getFromPortIndex() || memLink.getToLID() != newLink.getToLID() || memLink.getToPortIndex() != newLink.getToPortIndex()) continue;
            found = true;
            memLink.setActive(status);
            it.remove();
        }
        if (!found) {
            memLink.setActive(false);
        }
    }

    private void resetLinksUsingPortMap(NoticeProcess notice, Map<Short, PortState> portMap) {
        List links = (List)this.getCachedObject();
        int lid = notice.getLid();
        for (LinkRecordBean link : links) {
            PortState portState = null;
            if (link.getFromLID() == lid) {
                portState = portMap.get(link.getFromPortIndex());
            } else if (link.getToLID() == lid) {
                portState = portMap.get(link.getToPortIndex());
            }
            if (portState == null) continue;
            if (portState == PortState.ACTIVE) {
                link.setActive(true);
                continue;
            }
            link.setActive(false);
        }
    }
}

