/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.MFTRecordBean;
import com.intel.stl.api.subnet.impl.MFTCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MFTCacheImpl
extends MemoryCache<Map<Integer, List<MFTRecordBean>>>
implements MFTCache {
    private final SAHelper helper;

    public MFTCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<MFTRecordBean> getMFTs() {
        Map map = (Map)this.getCachedObject();
        List<MFTRecordBean> res = new ArrayList<MFTRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (List mfts : map.values()) {
                for (MFTRecordBean mft : mfts) {
                    res.add(mft);
                }
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getMFTs();
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public List<MFTRecordBean> getMFT(int lid) {
        Map map = (Map)this.getCachedObject();
        List<Object> res = new ArrayList();
        if (map != null) {
            res = (List)map.get(lid);
        }
        if (res != null && !res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getMFTs(lid);
            if (res != null && !res.isEmpty()) {
                this.setCacheReady(false);
            }
        }
        catch (Exception e) {
            log.error("Error getting MFT by lid " + lid, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    protected Map<Integer, List<MFTRecordBean>> retrieveObjectForCache() throws Exception {
        List<MFTRecordBean> mfts = this.helper.getMFTs();
        log.info("Retrieve " + (mfts == null ? 0 : mfts.size()) + " MFTs from FE");
        HashMap map = null;
        if (mfts != null) {
            map = new HashMap();
            for (MFTRecordBean mft : mfts) {
                int lid = mft.getLid();
                if (map.containsKey(lid)) {
                    ((List)map.get(lid)).add(mft);
                    continue;
                }
                ArrayList<MFTRecordBean> list = new ArrayList<MFTRecordBean>();
                list.add(mft);
                map.put(mft.getLid(), list);
            }
        }
        return map;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map map = (Map)this.getCachedObject();
        if (map != null && !map.isEmpty()) {
            map.remove(notice.getLid());
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

