/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.SC2VLMTRecordBean;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SC2VLNTMTCache;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SC2VLNTMTCacheImpl
extends MemoryCache<Map<Integer, List<SC2VLMTRecordBean>>>
implements SC2VLNTMTCache {
    private final SAHelper helper;

    public SC2VLNTMTCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLNTMTs() {
        Map map = (Map)this.getCachedObject();
        List<SC2VLMTRecordBean> res = new ArrayList<SC2VLMTRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (List sc2vlnts : map.values()) {
                for (SC2VLMTRecordBean sc2vlnt : sc2vlnts) {
                    res.add(sc2vlnt);
                }
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getSC2VLNTMTs();
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLNTMT(int lid) {
        Map map = (Map)this.getCachedObject();
        List<Object> res = new ArrayList();
        if (map != null) {
            res = (List)map.get(lid);
        }
        if (res != null && !res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getSC2VLNTMT(lid);
            if (res != null && !res.isEmpty()) {
                this.setCacheReady(false);
            }
        }
        catch (Exception e) {
            log.error("Error getting Cable Infos by lid " + lid, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    public SC2VLMTRecordBean getSC2VLNTMT(int lid, short portNum) {
        List sc2vlntmts;
        Map map = (Map)this.getCachedObject();
        if (map != null && (sc2vlntmts = (List)map.get(lid)) != null) {
            for (SC2VLMTRecordBean sc2vlnt : sc2vlntmts) {
                if (sc2vlnt.getLid() != lid || sc2vlnt.getPort() != portNum) continue;
                return sc2vlnt;
            }
        }
        try {
            List<SC2VLMTRecordBean> sc2vlntFromFE = this.helper.getSC2VLNTMT(lid);
            if (sc2vlntFromFE != null && !sc2vlntFromFE.isEmpty()) {
                this.setCacheReady(false);
                for (SC2VLMTRecordBean sc2vlnt : sc2vlntFromFE) {
                    if (sc2vlnt.getPort() != portNum) continue;
                    return sc2vlnt;
                }
            }
        }
        catch (Exception e) {
            log.error("Error getting SC2VLnt Infos by lid " + lid + ", portNum=" + portNum, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return null;
    }

    @Override
    protected Map<Integer, List<SC2VLMTRecordBean>> retrieveObjectForCache() throws Exception {
        List<SC2VLMTRecordBean> sc2vls = this.helper.getSC2VLNTMTs();
        log.info("Retrieve " + (sc2vls == null ? 0 : sc2vls.size()) + " SC2VLNTMT Infos from FE");
        HashMap map = null;
        if (sc2vls != null) {
            map = new HashMap();
            for (SC2VLMTRecordBean sc2vl : sc2vls) {
                int lid = sc2vl.getLid();
                if (map.containsKey(lid)) {
                    ((List)map.get(lid)).add(sc2vl);
                    continue;
                }
                ArrayList<SC2VLMTRecordBean> list = new ArrayList<SC2VLMTRecordBean>();
                list.add(sc2vl);
                map.put(sc2vl.getLid(), list);
            }
        }
        return map;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map map = (Map)this.getCachedObject();
        if (map != null && !map.isEmpty()) {
            map.remove(notice.getLid());
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

