/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.SMRecordBean;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SMCache;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SMCacheImpl
extends MemoryCache<Map<Integer, SMRecordBean>>
implements SMCache {
    private final SAHelper helper;

    public SMCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<SMRecordBean> getSMs() {
        Map map = (Map)this.getCachedObject();
        List<SMRecordBean> res = new ArrayList<SMRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (SMRecordBean sm : map.values()) {
                res.add(sm);
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getSMs();
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public SMRecordBean getSM(int lid) {
        Map map = (Map)this.getCachedObject();
        if (map != null) {
            return (SMRecordBean)map.get(lid);
        }
        return null;
    }

    @Override
    protected Map<Integer, SMRecordBean> retrieveObjectForCache() throws Exception {
        List<SMRecordBean> sms = this.helper.getSMs();
        log.info("Retrieve " + (sms == null ? 0 : sms.size()) + " SMs Infos from FE");
        HashMap<Integer, SMRecordBean> map = null;
        if (sms != null) {
            map = new HashMap<Integer, SMRecordBean>();
            for (SMRecordBean sm : sms) {
                map.put(sm.getLid(), sm);
            }
        }
        return map;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map map = (Map)this.getCachedObject();
        if (map != null && !map.isEmpty()) {
            map.remove(notice.getLid());
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

