/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.impl.SubnetContextImpl;
import com.intel.stl.api.subnet.CableRecordBean;
import com.intel.stl.api.subnet.FabricInfoBean;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.LFTRecordBean;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.MFTRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.P_KeyTableRecordBean;
import com.intel.stl.api.subnet.PathRecordBean;
import com.intel.stl.api.subnet.PortRecordBean;
import com.intel.stl.api.subnet.SC2SLMTRecordBean;
import com.intel.stl.api.subnet.SC2VLMTRecordBean;
import com.intel.stl.api.subnet.SMRecordBean;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.api.subnet.SubnetException;
import com.intel.stl.api.subnet.SwitchRecordBean;
import com.intel.stl.api.subnet.TraceRecordBean;
import com.intel.stl.api.subnet.VLArbTableRecordBean;
import com.intel.stl.api.subnet.impl.CableCache;
import com.intel.stl.api.subnet.impl.LFTCache;
import com.intel.stl.api.subnet.impl.LinkCache;
import com.intel.stl.api.subnet.impl.MFTCache;
import com.intel.stl.api.subnet.impl.NodeCache;
import com.intel.stl.api.subnet.impl.PKeyTableCache;
import com.intel.stl.api.subnet.impl.PortCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SC2SLMTCache;
import com.intel.stl.api.subnet.impl.SC2VLNTMTCache;
import com.intel.stl.api.subnet.impl.SC2VLTMTCache;
import com.intel.stl.api.subnet.impl.SwitchCache;
import com.intel.stl.api.subnet.impl.VLArbTableCache;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.fecdriver.messages.adapter.sa.GID;
import java.util.EnumMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetApi
implements ISubnetApi {
    private static Logger log = LoggerFactory.getLogger(SubnetApi.class);
    private final SubnetContextImpl subnetContext;
    private final CacheManager cacheMgr;

    public SubnetApi(SubnetContextImpl subnetContext) {
        this.subnetContext = subnetContext;
        this.cacheMgr = this.subnetContext.getCacheManager();
    }

    @Override
    public SubnetDescription getConnectionDescription() {
        return this.subnetContext.getSubnetDescription();
    }

    @Override
    public List<NodeRecordBean> getNodes(boolean includeInactive) throws SubnetDataNotFoundException {
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        return nodeCache.getNodes(includeInactive);
    }

    @Override
    public NodeRecordBean getNode(int lid) throws SubnetDataNotFoundException {
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        return nodeCache.getNode(lid);
    }

    @Override
    public NodeRecordBean getNode(long portGuid) throws SubnetDataNotFoundException {
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        return nodeCache.getNode(portGuid);
    }

    @Override
    public EnumMap<NodeType, Integer> getNodesTypeDist(boolean includeInactive, boolean refresh) throws SubnetDataNotFoundException {
        NodeCache nodeCache = this.cacheMgr.acquireNodeCache();
        return nodeCache.getNodesTypeDist(includeInactive, refresh);
    }

    @Override
    public List<LinkRecordBean> getLinks(boolean includeInactive) throws SubnetDataNotFoundException {
        LinkCache linkCache = this.cacheMgr.acquireLinkCache();
        return linkCache.getLinks(includeInactive);
    }

    @Override
    public LinkRecordBean getLinkBySource(int lid, short portNum) throws SubnetDataNotFoundException {
        LinkCache linkCache = this.cacheMgr.acquireLinkCache();
        return linkCache.getLinkBySource(lid, portNum);
    }

    @Override
    public LinkRecordBean getLinkByDestination(int lid, short portNum) throws SubnetDataNotFoundException {
        LinkCache linkCache = this.cacheMgr.acquireLinkCache();
        return linkCache.getLinkByDestination(lid, portNum);
    }

    @Override
    public List<PortRecordBean> getPorts() throws SubnetDataNotFoundException {
        PortCache portCache = this.cacheMgr.acquirePortCache();
        return portCache.getPorts();
    }

    @Override
    public PortRecordBean getPortByPortNum(int lid, short portNum) throws SubnetDataNotFoundException {
        PortCache portCache = this.cacheMgr.acquirePortCache();
        return portCache.getPortByPortNum(lid, portNum);
    }

    @Override
    public PortRecordBean getPortByLocalPortNum(int lid, short localPortNum) throws SubnetDataNotFoundException {
        PortCache portCache = this.cacheMgr.acquirePortCache();
        return portCache.getPortByLocalPortNum(lid, localPortNum);
    }

    @Override
    public boolean hasPort(int lid, short portNum) {
        PortCache portCache = this.cacheMgr.acquirePortCache();
        return portCache.hasPort(lid, portNum);
    }

    @Override
    public boolean hasLocalPort(int lid, short localPortNum) {
        PortCache portCache = this.cacheMgr.acquirePortCache();
        return portCache.hasLocalPort(lid, localPortNum);
    }

    @Override
    public EnumMap<NodeType, Long> getPortsTypeDist(boolean countInternalMgrPort, boolean refresh) throws SubnetDataNotFoundException {
        PortCache portCache = this.cacheMgr.acquirePortCache();
        return portCache.getPortsTypeDist(countInternalMgrPort, refresh);
    }

    public long getSubnetPrefix() {
        PortCache portCache = this.cacheMgr.acquirePortCache();
        return portCache.getSubnetPrefix();
    }

    @Override
    public List<SwitchRecordBean> getSwitches() {
        SwitchCache switchCache = this.cacheMgr.acquireSwitchCache();
        return switchCache.getSwitches();
    }

    @Override
    public SwitchRecordBean getSwitch(int lid) {
        SwitchCache switchCache = this.cacheMgr.acquireSwitchCache();
        return switchCache.getSwitch(lid);
    }

    @Override
    public List<LFTRecordBean> getLFTs() {
        LFTCache lftCache = this.cacheMgr.acquireLFTCache();
        return lftCache.getLFTs();
    }

    @Override
    public List<LFTRecordBean> getLFT(int lid) {
        LFTCache lftCache = this.cacheMgr.acquireLFTCache();
        return lftCache.getLFT(lid);
    }

    @Override
    public List<MFTRecordBean> getMFTs() {
        MFTCache mftCache = this.cacheMgr.acquireMFTCache();
        return mftCache.getMFTs();
    }

    @Override
    public List<MFTRecordBean> getMFT(int lid) {
        MFTCache mftCache = this.cacheMgr.acquireMFTCache();
        return mftCache.getMFT(lid);
    }

    @Override
    public List<P_KeyTableRecordBean> getPKeyTables() {
        PKeyTableCache pkeyTableCache = this.cacheMgr.acquirePKeyTableCache();
        return pkeyTableCache.getPKeyTables();
    }

    @Override
    public List<VLArbTableRecordBean> getVLArbTables() {
        VLArbTableCache vlarbTableCache = this.cacheMgr.acquireVLArbTableCache();
        return vlarbTableCache.getVLArbTables();
    }

    @Override
    public List<SMRecordBean> getSMs() {
        try {
            return this.getHelper().getSMs();
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public SMRecordBean getSM(int lid) {
        try {
            List<SMRecordBean> all = this.getHelper().getSMs();
            if (all != null) {
                for (SMRecordBean sm : all) {
                    if (sm.getLid() != lid) continue;
                    return sm;
                }
            }
            throw new SubnetDataNotFoundException((IMessage)STLMessages.STL40006_SMRECORD_NOT_FOUND, lid);
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public List<CableRecordBean> getCables() {
        CableCache cableCache = this.cacheMgr.acquireCableCache();
        return cableCache.getCables();
    }

    @Override
    public List<CableRecordBean> getCable(int lid) {
        CableCache cableCache = this.cacheMgr.acquireCableCache();
        return cableCache.getCable(lid);
    }

    @Override
    public List<CableRecordBean> getCable(int lid, short portNum) {
        CableCache cableCache = this.cacheMgr.acquireCableCache();
        return cableCache.getCable(lid, portNum);
    }

    @Override
    public List<SC2SLMTRecordBean> getSC2SLMTs() {
        SC2SLMTCache sc2slCache = this.cacheMgr.acquireSC2SLMTCache();
        return sc2slCache.getSC2SLMTs();
    }

    @Override
    public SC2SLMTRecordBean getSC2SLMT(int lid) {
        SC2SLMTCache sc2slCache = this.cacheMgr.acquireSC2SLMTCache();
        return sc2slCache.getSC2SLMT(lid);
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLTMTs() {
        SC2VLTMTCache sc2vltCache = this.cacheMgr.acquireSC2VLTMTCache();
        return sc2vltCache.getSC2VLTMTs();
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLTMT(int lid) {
        SC2VLTMTCache sc2vltCache = this.cacheMgr.acquireSC2VLTMTCache();
        return sc2vltCache.getSC2VLTMT(lid);
    }

    @Override
    public SC2VLMTRecordBean getSC2VLTMT(int lid, short portNum) {
        SC2VLTMTCache sc2vltCache = this.cacheMgr.acquireSC2VLTMTCache();
        return sc2vltCache.getSC2VLTMT(lid, portNum);
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLNTMTs() {
        SC2VLNTMTCache sc2vlntCache = this.cacheMgr.acquireSC2VLNTMTCache();
        return sc2vlntCache.getSC2VLNTMTs();
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLNTMT(int lid) {
        SC2VLNTMTCache sc2vlntCache = this.cacheMgr.acquireSC2VLNTMTCache();
        return sc2vlntCache.getSC2VLNTMT(lid);
    }

    @Override
    public SC2VLMTRecordBean getSC2VLNTMT(int lid, short portNum) {
        SC2VLNTMTCache sc2vltCache = this.cacheMgr.acquireSC2VLNTMTCache();
        return sc2vltCache.getSC2VLNTMT(lid, portNum);
    }

    @Override
    public List<PathRecordBean> getPath(int lid) {
        List<PathRecordBean> res = null;
        try {
            res = this.getHelper().getPath(this.getGid(lid));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    public List<TraceRecordBean> getTrace(int sourceLid, int targetLid) {
        List<TraceRecordBean> res = null;
        try {
            long nodeId;
            GID.Global sourceGid = this.getGid(sourceLid);
            res = this.getHelper().getTrace(sourceGid, this.getGid(targetLid));
            if (res != null && !res.isEmpty() && (nodeId = res.get(0).getNodeId()) != sourceGid.getInterfaceId()) {
                for (TraceRecordBean bean : res) {
                    long raw = bean.getNodeId() ^ 0x55555555L;
                    bean.setNodeId(Long.reverseBytes(raw) ^ 0x55555555L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    public FabricInfoBean getFabricInfo() {
        FabricInfoBean res = null;
        try {
            res = this.getHelper().getFabricInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    public GID.Global getGid(int lid) throws SubnetDataNotFoundException {
        NodeRecordBean node = this.getNode(lid);
        return new GID.Global(this.getSubnetPrefix(), node.getNodeInfo().getPortGUID());
    }

    public static SubnetException getSubnetException(Exception e) {
        SubnetException se = new SubnetException((IMessage)STLMessages.STL60002_SUBNET_DATA_FAILURE, (Throwable)e, StringUtils.getErrorMessage(e));
        log.error(StringUtils.getErrorMessage(se), (Throwable)e);
        return se;
    }

    private SAHelper getHelper() {
        return this.subnetContext.getSession().getSAHelper();
    }

    @Override
    public void reset() {
    }

    @Override
    public void cleanup() {
    }

    protected CacheManager getCacheManager() {
        return this.cacheMgr;
    }
}

