/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CircularBuffer<K, V> {
    private final long lifeSpan;
    private final ArrayBlockingQueue<BufferItem<K, V>> buffer;
    private final ConcurrentLinkedQueue<V> saveQueue;

    public CircularBuffer(int lifeSpanInSeconds) {
        this(lifeSpanInSeconds, 10);
    }

    public CircularBuffer(long lifeSpanInSeconds, int size) {
        this.lifeSpan = lifeSpanInSeconds * 1000L;
        this.buffer = new ArrayBlockingQueue(size);
        this.saveQueue = new ConcurrentLinkedQueue();
    }

    public void put(K key, V value) {
        BufferItem<K, V> item = new BufferItem<K, V>(key, value);
        if (this.get(key) != null) {
            return;
        }
        while (!this.buffer.offer(item)) {
            this.saveQueue.add(this.buffer.poll().getValue());
        }
    }

    public List<V> purgeSaveQueue() {
        ArrayList<V> result = new ArrayList<V>(this.saveQueue.size());
        while (!this.saveQueue.isEmpty()) {
            V value = this.saveQueue.poll();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public int getSaveQueueSize() {
        return this.saveQueue.size();
    }

    public V get(K key) {
        Iterator<BufferItem<K, V>> it = this.buffer.iterator();
        while (it.hasNext()) {
            BufferItem<K, V> item = it.next();
            if (!item.getKey().equals(key)) continue;
            if (item.isValid()) {
                return item.getValue();
            }
            it.remove();
        }
        return null;
    }

    private class BufferItem<I, L> {
        private final long timeStamp = System.currentTimeMillis();
        private final I key;
        private final L value;

        public BufferItem(I key, L value) {
            this.key = key;
            this.value = value;
        }

        public I getKey() {
            return this.key;
        }

        public L getValue() {
            return this.value;
        }

        public boolean isValid() {
            return System.currentTimeMillis() - this.timeStamp < CircularBuffer.this.lifeSpan;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BufferItem)) {
                return false;
            }
            BufferItem other = (BufferItem)obj;
            return this.key.equals(other.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

