/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.common;

import java.nio.ByteBuffer;

public class StringUtils {
    public static String toString(byte[] raw, int offset, int maxLen) {
        int pos;
        if (raw == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        if (offset >= raw.length) {
            throw new IllegalArgumentException("Invalid offset (" + offset + ">=" + raw.length + ")");
        }
        int end = offset + Math.min(maxLen, raw.length - offset);
        for (pos = offset; pos < end && raw[pos] != 0; ++pos) {
        }
        return pos > offset ? new String(raw, offset, pos - offset) : "";
    }

    public static void setString(String str, ByteBuffer buffer, int startPos, int maxLen) throws IllegalArgumentException {
        if (str == null || buffer == null) {
            return;
        }
        if (str.length() >= maxLen) {
            throw new IllegalArgumentException("Invalid string length " + str.length() + " > " + 64 + ".");
        }
        buffer.position(startPos);
        buffer.put(str.getBytes());
    }
}

