/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.configuration.ProcessingService;
import com.intel.stl.configuration.ResultHandler;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

public class BaseProcessingService
implements ProcessingService {
    private static final int DEFAULT_POOL_SIZE = 2;
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 1000L;
    private final ExecutorService processingService;

    public BaseProcessingService() {
        this(Executors.newFixedThreadPool(2));
    }

    public BaseProcessingService(ExecutorService service) {
        this.processingService = service;
    }

    @Override
    public <T> void submit(AsyncTask<T> task, ResultHandler<T> handler) {
        if (this.processingService.isShutdown()) {
            return;
        }
        this.executeTask(task, handler, this.processingService);
    }

    @Override
    public void shutdown() {
        this.shutdownService(this.processingService, 1000L);
    }

    @Override
    public void shutdown(long timeout) {
        this.shutdownService(this.processingService, timeout);
    }

    protected synchronized <T> void executeTask(AsyncTask<T> task, ResultHandler<T> handler, ExecutorService executor) {
        FutureTask<T> currFuture = task.getFuture();
        if (currFuture == null) {
            task.setLoggingContextMap(MDC.getCopyOfContextMap());
            AsyncFutureTask<T> future = new AsyncFutureTask<T>(task, handler);
            task.setFuture(future);
            future.setClientTrace(new Exception("Caller's stack trace"));
            executor.execute(future);
        }
    }

    protected void shutdownService(ExecutorService executor, long millis) {
        executor.shutdown();
        try {
            executor.awaitTermination(millis, TimeUnit.MILLISECONDS);
            if (!executor.isTerminated()) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected class AsyncFutureTask<V>
    extends FutureTask<V> {
        private Exception clientTrace;
        private final ResultHandler<V> handler;

        public AsyncFutureTask(Callable<V> callable, ResultHandler<V> handler) {
            super(callable);
            this.handler = handler;
        }

        @Override
        protected void setException(Throwable t) {
            if (this.clientTrace != null) {
                t.addSuppressed(this.clientTrace);
            }
            super.setException(t);
        }

        @Override
        protected void done() {
            if (this.handler != null) {
                this.handler.onTaskCompleted(this);
            }
        }

        protected void setClientTrace(Exception clientTrace) {
            this.clientTrace = clientTrace;
        }

        protected Exception getClientTrace() {
            return this.clientTrace;
        }
    }
}

