/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.api.subnet.impl.DBLinkCacheImpl;
import com.intel.stl.api.subnet.impl.DBNodeCacheImpl;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.ManagedCache;
import com.intel.stl.configuration.MemCacheType;

public enum DBCacheType {
    NODE(DBNodeCacheImpl.class, MemCacheType.NODE),
    LINK(DBLinkCacheImpl.class, MemCacheType.LINK);

    private final Class<? extends ManagedCache> implementingClass;
    private final MemCacheType memCacheType;

    private DBCacheType(Class<? extends ManagedCache> implementingClass, MemCacheType memCacheType) {
        this.implementingClass = implementingClass;
        this.memCacheType = memCacheType;
    }

    public String getImplementingClassName() {
        return this.implementingClass.getCanonicalName();
    }

    public MemCacheType getMemCacheType() {
        return this.memCacheType;
    }

    public ManagedCache getInstance(CacheManager cacheManager) throws Exception {
        ManagedCache cache = this.implementingClass.getConstructor(CacheManager.class).newInstance(cacheManager);
        return cache;
    }
}

