/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.BaseCache;
import com.intel.stl.configuration.CacheManager;
import java.lang.ref.SoftReference;

public abstract class MemoryCache<H>
extends BaseCache {
    public static final long DEFAULT_TICK_RESOLUTION = 9000L;
    private SoftReference<H> cachedObjectReference = new SoftReference<Object>(null);
    private RuntimeException refreshException;
    private long tickResolution = 9000L;

    public MemoryCache(CacheManager cacheMgr) {
        super(cacheMgr);
    }

    public long getTickResolution() {
        return this.tickResolution;
    }

    public void setTickResolution(long tickResolution) {
        this.tickResolution = tickResolution;
    }

    protected H getCachedObject() {
        if (this.refreshException != null) {
            throw this.refreshException;
        }
        H res = this.cachedObjectReference.get();
        if (res == null) {
            this.updateCache();
            res = this.cachedObjectReference.get();
        }
        return res;
    }

    protected void setCachedObject(H cachedObject) {
        this.cachedObjectReference = new SoftReference<H>(cachedObject);
    }

    protected RuntimeException getRefreshException() {
        return this.refreshException;
    }

    @Override
    public boolean isCacheReady() {
        if (this.cachedObjectReference.get() == null) {
            this.cacheReady.set(false);
        }
        return this.cacheReady.get();
    }

    @Override
    public boolean refreshCache() {
        this.refreshException = null;
        try {
            H cachedObject = this.retrieveObjectForCache();
            this.setCachedObject(cachedObject);
            this.refreshException = null;
            return true;
        }
        catch (Exception e) {
            this.setCachedObject(null);
            this.refreshException = this.processRefreshCacheException(e);
            return false;
        }
    }

    @Override
    public void reset() {
        this.setCachedObject(null);
    }

    protected abstract H retrieveObjectForCache() throws Exception;

    protected RuntimeException processRefreshCacheException(Exception e) {
        String errorMsg = STLMessages.STL60006_EXCEPTION_REFRESHING_CACHE.getDescription(this.getClass().getSimpleName(), e.getMessage());
        log.error(errorMsg, (Throwable)e);
        return new RuntimeException(errorMsg, e);
    }
}

