/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.datamanager.GroupConfigId;
import com.intel.stl.datamanager.GroupConfigRecord;
import com.intel.stl.datamanager.GroupInfoId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;

@Entity
@Table(name="GROUP_INFOS")
public class GroupInfoRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private GroupInfoId id = new GroupInfoId();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="subnetName", insertable=false, updatable=false), @JoinColumn(name="groupName", insertable=false, updatable=false)})
    private GroupConfigRecord groupConfig;
    private GroupInfoBean groupInfo;
    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    @CollectionTable(name="GROUP_INFOS_INTERNAL_BWBUCKETS", joinColumns={@JoinColumn(name="subnetId"), @JoinColumn(name="groupName"), @JoinColumn(name="sweepTimestamp")})
    private List<Integer> internalBwBuckets;
    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    @CollectionTable(name="GROUP_INFOS_SEND_BWBUCKETS", joinColumns={@JoinColumn(name="subnetId"), @JoinColumn(name="groupName"), @JoinColumn(name="sweepTimestamp")})
    private List<Integer> sendBwBuckets;
    @ElementCollection(fetch=FetchType.EAGER)
    @OrderColumn
    @CollectionTable(name="GROUP_INFOS_RECEIVE_BWBUCKETS", joinColumns={@JoinColumn(name="subnetId"), @JoinColumn(name="groupName"), @JoinColumn(name="sweepTimestamp")})
    private List<Integer> receiveBwBuckets;

    public GroupInfoRecord() {
    }

    public GroupInfoRecord(long subnetId, GroupInfoBean groupInfo) {
        GroupConfigId groupId = this.id.getGroupID();
        if (groupId == null) {
            groupId = new GroupConfigId();
            this.id.setGroupID(groupId);
        }
        groupId.setFabricId(subnetId);
        groupId.setSubnetGroup(groupInfo.getGroupName());
        this.id.setSweepTimestamp(groupInfo.getTimestamp());
        this.setGroupInfo(groupInfo);
    }

    public GroupInfoId getId() {
        return this.id;
    }

    public void setId(GroupInfoId id) {
        this.id = id;
    }

    public GroupConfigRecord getGroupConfig() {
        return this.groupConfig;
    }

    public void setGroupConfig(GroupConfigRecord groupConfig) {
        this.groupConfig = groupConfig;
    }

    public GroupInfoBean getGroupInfo() {
        if (this.groupInfo.getInternalUtilStats() != null) {
            this.groupInfo.getInternalUtilStats().setBwBuckets(this.internalBwBuckets);
        }
        if (this.groupInfo.getSendUtilStats() != null) {
            this.groupInfo.getSendUtilStats().setBwBuckets(this.sendBwBuckets);
        }
        if (this.groupInfo.getRecvUtilStats() != null) {
            this.groupInfo.getRecvUtilStats().setBwBuckets(this.receiveBwBuckets);
        }
        return this.groupInfo;
    }

    public void setGroupInfo(GroupInfoBean groupInfo) {
        if (groupInfo != null) {
            this.internalBwBuckets = groupInfo.getInternalUtilStats() != null ? groupInfo.getInternalUtilStats().getBwBuckets() : new ArrayList<Integer>();
            this.sendBwBuckets = groupInfo.getSendUtilStats() != null ? groupInfo.getSendUtilStats().getBwBuckets() : new ArrayList<Integer>();
            this.receiveBwBuckets = groupInfo.getRecvUtilStats() != null ? groupInfo.getRecvUtilStats().getBwBuckets() : new ArrayList<Integer>();
        } else {
            this.internalBwBuckets = new ArrayList<Integer>();
            this.sendBwBuckets = new ArrayList<Integer>();
            this.receiveBwBuckets = new ArrayList<Integer>();
        }
        this.groupInfo = groupInfo;
    }

    public List<Integer> getInternalBwBuckets() {
        return this.internalBwBuckets;
    }

    public void setInternalBwBuckets(List<Integer> internalBwBuckets) {
        this.internalBwBuckets = internalBwBuckets;
    }

    public List<Integer> getSendBwBuckets() {
        return this.sendBwBuckets;
    }

    public void setSendBwBuckets(List<Integer> sendBwBuckets) {
        this.sendBwBuckets = sendBwBuckets;
    }

    public List<Integer> getReceiveBwBuckets() {
        return this.receiveBwBuckets;
    }

    public void setReceiveBwBuckets(List<Integer> receiveBwBuckets) {
        this.receiveBwBuckets = receiveBwBuckets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupInfoRecord other = (GroupInfoRecord)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

