/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.dbengine.DatabaseEngine;
import com.intel.stl.dbengine.impl.DatabaseUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.EntityManager;
import org.hsqldb.Server;
import org.hsqldb.jdbc.JDBCPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbEngine
implements DatabaseEngine {
    private static Logger log = LoggerFactory.getLogger(HSqlDbEngine.class);
    private static final String DB_ENGINE_NAME = "HSQLDB";
    private static final String DB_ENGINE_VERSION = "2.3";
    public static final String DB_DEFINITION_FILE = "hsqldbdef.sql";
    private static final String HSQLDB_SERVER_URL = "jdbc:hsqldb:hsql:";
    private static final int HSQLDB_SERVER_DEFAULT_PORT = 9001;
    private static final String LOCALHOST_SERVER = "localhost";
    private static final String SLASHES = "//";
    private final String databaseDefinition;
    private String databaseFolder;
    private String databaseName;
    private String connectionUrl;
    private String user;
    private Server server;
    private final JDBCPool pool;

    public HSqlDbEngine(AppSettings settings) throws AppConfigurationException {
        this(settings, DB_DEFINITION_FILE, new JDBCPool());
    }

    public HSqlDbEngine(AppSettings settings, String definitionFile) throws AppConfigurationException {
        this(settings, definitionFile, new JDBCPool());
    }

    public HSqlDbEngine(AppSettings settings, String definitionFile, JDBCPool pool) throws AppConfigurationException {
        this.applySettings(settings);
        this.databaseDefinition = definitionFile;
        this.pool = pool;
        String password = settings.getConfigOption("db.connection.password");
        pool.setUrl(this.connectionUrl);
        pool.setUser(this.user);
        pool.setPassword(password);
    }

    private void applySettings(AppSettings settings) throws AppConfigurationException {
        String connectionUrl;
        this.databaseFolder = settings.getConfigOption("app.db.path");
        this.databaseName = settings.getConfigOption("db.name");
        this.user = settings.getConfigOption("db.connection.user");
        try {
            connectionUrl = settings.getConfigOption("db.connection.url");
        }
        catch (AppConfigurationException e) {
            log.info(e.getMessage());
            connectionUrl = null;
        }
        this.connectionUrl = connectionUrl == null ? "jdbc:hsqldb:file:" + this.databaseFolder + File.separatorChar + this.databaseName + ";hsqldb.default_table_type=cached" : connectionUrl;
    }

    @Override
    public void start() throws DatabaseException {
        String urlPrefix = this.getConnectionUrlPrefix();
        String host = this.getConnectionUrlHost();
        if (HSQLDB_SERVER_URL.equalsIgnoreCase(urlPrefix) && LOCALHOST_SERVER.equalsIgnoreCase(host)) {
            this.server = new Server();
            this.server.setDaemon(true);
            this.server.setDatabasePath(0, this.databaseFolder);
            this.server.setDatabaseName(0, this.databaseName);
            int port = this.getConnectionUrlPort();
            this.server.setPort(port);
            this.server.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean compact) throws DatabaseException {
        Connection conn = this.getConnection();
        try {
            try (PreparedStatement shutdown = conn.prepareStatement("SHUTDOWN COMPACT");){
                shutdown.execute();
            }
            conn.close();
        }
        catch (SQLException e) {
            log.error(STLMessages.STL30006_SQLEXCEPTION.getDescription(e.getErrorCode(), StringUtils.getErrorMessage(e)), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSchema() throws AppConfigurationException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            try (PreparedStatement drop = conn.prepareStatement("DROP SCHEMA PUBLIC CASCADE");){
                drop.execute();
            }
            DatabaseUtils.defineDatabase(conn, this.databaseDefinition);
            if (!DatabaseUtils.checkDatabase(conn)) {
                DatabaseUtils.defineDatabase(conn, this.databaseDefinition);
            }
        }
        catch (SQLException e) {
            AppConfigurationException ace = new AppConfigurationException("SQLException", e);
            throw ace;
        }
        catch (DatabaseException e) {
            AppConfigurationException ace = new AppConfigurationException("DatabaseException", e);
            throw ace;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            String errMsg = STLMessages.STL30007_ERROR_STARTING_DB_ENGINE.getDescription(DB_ENGINE_NAME, "close()", e.getErrorCode());
            log.error(errMsg, (Throwable)e);
            AppConfigurationException ace = new AppConfigurationException(errMsg, e);
            throw ace;
        }
    }

    private void checkSchemaTimestamp() throws DatabaseException {
        long defTimestamp = DatabaseUtils.getDatabaseDefinitionTimestamp(DB_DEFINITION_FILE);
    }

    @Override
    public Connection getConnection() throws DatabaseException {
        Connection conn = null;
        try {
            conn = this.pool.getConnection();
        }
        catch (SQLException e) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30006_SQLEXCEPTION, (Throwable)e, e.getErrorCode(), StringUtils.getErrorMessage(e));
            log.error(dbe.getMessage(), (Throwable)e);
            throw dbe;
        }
        return conn;
    }

    @Override
    public EntityManager getEntityManager() {
        return null;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getEngineName() {
        return DB_ENGINE_NAME;
    }

    @Override
    public String getEngineVersion() {
        return DB_ENGINE_VERSION;
    }

    private void renameDbFolder() {
        Date dateSuffix = new Date();
        File dbFolder = new File(this.databaseFolder);
        String rename = this.databaseFolder + "-" + new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss").format(dateSuffix);
        File dbFolderRename = new File(rename);
        if (!dbFolder.renameTo(dbFolderRename)) {
            // empty if block
        }
    }

    @Override
    public AppInfo getAppInfo() {
        return null;
    }

    @Override
    public void saveAppInfo(AppInfo info) throws DatabaseException {
    }

    private String getConnectionUrlPrefix() {
        return this.connectionUrl.substring(0, HSQLDB_SERVER_URL.length());
    }

    private String getConnectionUrlHost() {
        int colon;
        int x = HSQLDB_SERVER_URL.length();
        if (x <= this.connectionUrl.length()) {
            return "";
        }
        String slashes = this.connectionUrl.substring(x, x + 2);
        if (SLASHES.equalsIgnoreCase(slashes)) {
            x += 2;
        }
        if ((colon = this.connectionUrl.indexOf(":", x)) >= 0) {
            return this.connectionUrl.substring(x, colon);
        }
        int slash = this.connectionUrl.indexOf("/", x);
        if (slash >= 0) {
            return this.connectionUrl.substring(x, slash);
        }
        return this.connectionUrl.substring(x);
    }

    private int getConnectionUrlPort() {
        int x = HSQLDB_SERVER_URL.length();
        if (x < this.connectionUrl.length()) {
            return 9001;
        }
        int colon = this.connectionUrl.indexOf(":", x);
        if (colon >= 0) {
            int slash = this.connectionUrl.indexOf("/", colon + 1);
            if (slash >= 0) {
                return Integer.parseInt(this.connectionUrl.substring(colon + 1, slash));
            }
            return Integer.parseInt(this.connectionUrl.substring(colon + 1));
        }
        return 9001;
    }
}

