/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.datamanager.DatabaseCall;
import com.intel.stl.dbengine.DatabaseServer;
import com.intel.stl.dbengine.Scheduler;
import com.intel.stl.dbengine.impl.DatabaseThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerImpl
implements Scheduler {
    private static Logger log = LoggerFactory.getLogger(SchedulerImpl.class);
    private final ExecutorService pool;
    private final DatabaseServer server;

    public SchedulerImpl(DatabaseServer server, int poolSize) {
        this.server = server;
        DatabaseThreadFactory threadFactory = new DatabaseThreadFactory(server);
        this.pool = Executors.newFixedThreadPool(poolSize, threadFactory);
    }

    @Override
    public synchronized <T> Future<T> enqueue(DatabaseCall<T> workItem) {
        workItem.setDatabaseServer(this.server);
        workItem.setClientTrace(new Exception("Caller's stack trace"));
        Future<T> future = this.pool.submit(workItem);
        workItem.setFuture(future);
        return future;
    }

    @Override
    public void shutdown() {
        log.info("Scheduler shutdown in progress");
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(2L, TimeUnit.SECONDS);
            if (!this.pool.isTerminated()) {
                this.pool.shutdownNow();
            }
            log.info("Scheduler shutdown complete.");
        }
        catch (InterruptedException e) {
            log.info("Scheduler shutdown interrupted.", (Throwable)e);
        }
    }
}

