/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.DefaultConnectionAssistant;
import com.intel.stl.api.FMException;
import com.intel.stl.api.IConnectionAssistant;
import com.intel.stl.api.SSLStoreCredentialsDeniedException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.failure.BaseTaskFailure;
import com.intel.stl.api.failure.IFailureEvaluator;
import com.intel.stl.api.failure.IFailureManagement;
import com.intel.stl.api.failure.ITaskFailure;
import com.intel.stl.api.notice.GenericNoticeAttrBean;
import com.intel.stl.api.notice.IEventListener;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.NoticeType;
import com.intel.stl.api.notice.TrapType;
import com.intel.stl.api.notice.impl.NoticeSaveTask;
import com.intel.stl.api.subnet.GIDGlobal;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.ResultHandler;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.fecdriver.ApplicationEvent;
import com.intel.stl.fecdriver.ICommand;
import com.intel.stl.fecdriver.IFailoverEventListener;
import com.intel.stl.fecdriver.IFailoverManager;
import com.intel.stl.fecdriver.IFailoverProgressListener;
import com.intel.stl.fecdriver.IResponse;
import com.intel.stl.fecdriver.adapter.IAdapter;
import com.intel.stl.fecdriver.adapter.ISMEventListener;
import com.intel.stl.fecdriver.dispatcher.Connection;
import com.intel.stl.fecdriver.dispatcher.ConnectionPoolingPolicy;
import com.intel.stl.fecdriver.dispatcher.DispatcherThreadFactory;
import com.intel.stl.fecdriver.dispatcher.IConnectionEventListener;
import com.intel.stl.fecdriver.dispatcher.IPoolingPolicy;
import com.intel.stl.fecdriver.dispatcher.IRequestDispatcher;
import com.intel.stl.fecdriver.dispatcher.Reactor;
import com.intel.stl.fecdriver.dispatcher.SecureConnection;
import com.intel.stl.fecdriver.session.ISession;
import com.intel.stl.fecdriver.session.Session;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SubnetRequestDispatcher
extends Reactor<Connection, Void>
implements IRequestDispatcher,
IConnectionEventListener,
IEventListener<NoticeBean>,
IFailoverProgressListener {
    private static Logger log = LoggerFactory.getLogger(SubnetRequestDispatcher.class);
    private static final int THREAD_POOL_SIZE = 3;
    protected static int MAX_CONN_POOL_SIZE = 10;
    public static int MIN_CONN_POOL_SIZE = 3;
    private static final String THREAD_NAME_PREFIX = "srdthread-";
    private boolean running;
    private boolean connectivityError = false;
    private boolean failoverInProgress = false;
    private boolean failoverMgrRunning = false;
    private Exception connectivityException;
    private final AtomicInteger connCompleted = new AtomicInteger(0);
    private final AtomicReference<Connection> noticeConnection = new AtomicReference<Object>(null);
    private int invConnections = 0;
    private int targetNumConnections = 0;
    private int lastNumSessions = 0;
    private HostInfo hostInfo;
    private final ConcurrentLinkedQueue<Reactor.HandlerTask> pendingResults = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PendingCommand> pendingCmds = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Connection> pendingConns = new ConcurrentLinkedQueue();
    private final List<ISMEventListener> snEventListeners = new CopyOnWriteArrayList<ISMEventListener>();
    protected final List<ISession> sessions = Collections.synchronizedList(new ArrayList());
    protected final List<Connection> connPool;
    private final SubnetDescription subnet;
    private final IAdapter adapter;
    private final DatabaseManager dbMgr;
    private final IPoolingPolicy<Connection> poolingPolicy;
    private final Selector selector;

    public SubnetRequestDispatcher(SubnetDescription subnet, IAdapter adapter, DatabaseManager dbMgr) throws IOException {
        this(subnet, adapter, dbMgr, new ConnectionPoolingPolicy(MAX_CONN_POOL_SIZE, MIN_CONN_POOL_SIZE), Selector.open());
    }

    public SubnetRequestDispatcher(SubnetDescription subnet, IAdapter adapter, DatabaseManager dbMgr, IPoolingPolicy<Connection> poolingPolicy) throws IOException {
        this(subnet, adapter, dbMgr, poolingPolicy, Selector.open());
    }

    protected SubnetRequestDispatcher(SubnetDescription subnet, IAdapter adapter, DatabaseManager dbMgr, IPoolingPolicy<Connection> poolingPolicy, Selector selector) {
        super(Executors.newFixedThreadPool(3, new DispatcherThreadFactory(THREAD_NAME_PREFIX, subnet)));
        this.subnet = subnet;
        this.adapter = adapter;
        this.dbMgr = dbMgr;
        this.selector = selector;
        this.connPool = Collections.synchronizedList(new ArrayList());
        this.poolingPolicy = poolingPolicy;
        this.setName(THREAD_NAME_PREFIX + subnet.getSubnetId());
        this.setDaemon(true);
        this.running = true;
        IConnectionAssistant assistant = subnet.getConnectionAssistant();
        for (HostInfo host : subnet.getFEList()) {
            host.setConnectionAssistant(assistant);
        }
        this.setHostInfo();
    }

    @Override
    public ISession createSession() {
        Session session = new Session(this);
        this.sessions.add(session);
        this.wakeupDispatcher();
        return session;
    }

    @Override
    public ISession createSession(ISMEventListener listener) {
        if (listener != null) {
            this.snEventListeners.add(listener);
        }
        return this.createSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ISession session) {
        List<ISession> list = this.sessions;
        synchronized (list) {
            Iterator<ISession> it = this.sessions.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(session)) continue;
                it.remove();
                break;
            }
        }
        if (this.sessions.size() == 0) {
            this.adapter.shutdownSubnet(this.subnet);
        } else {
            this.wakeupDispatcher();
        }
    }

    @Override
    public void cancelFailover() {
        if (this.failoverMgrRunning) {
            super.interrupt();
        }
    }

    @Override
    public <E extends IResponse<F>, F> void queueCmd(ICommand<E, F> cmd) {
        if (this.connectivityError) {
            cmd.getResponse().setError(this.connectivityException);
        } else {
            this.addPendingCommand(cmd, null);
            this.wakeupDispatcher();
        }
    }

    @Override
    protected void onHandlerDone(Reactor.HandlerTask future) {
        this.pendingResults.add(future);
        this.wakeupDispatcher();
    }

    @Override
    public void onRequestTimeout(TimeoutException toe) {
        Reactor.HandlerTask future = this.createHandlerTask(new ConnectionTimeout(toe));
        try {
            future.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.onHandlerDone(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MDC.put((String)"subnet", (String)this.subnet.getName());
        try {
            log.info("Starting Subnet Request Dispatcher for subnet {}", (Object)this.subnet.getName());
            this.targetNumConnections = this.resizeConnectionPool();
            this.processPendingConnections();
            while (this.running) {
                try {
                    this.selector.select();
                }
                catch (IOException e) {
                    log.error("selector.selection exception: " + e.getMessage(), (Throwable)e);
                    break;
                }
                if (this.lastNumSessions != this.sessions.size()) {
                    this.targetNumConnections += this.resizeConnectionPool();
                }
                this.processPendingConnections();
                this.processPendingResults();
                this.processPendingCmds();
                this.processSelectedKeys();
            }
            this.closeConnections();
        }
        finally {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                log.debug("IOException closing selector", (Throwable)e);
            }
            this.running = false;
            log.info("Subnet Request Dispatcher for subnet {} has been shut down.", (Object)this.subnet.getName());
        }
    }

    @Override
    public void onConnectionComplete(Connection connection) {
        int numConn = this.connCompleted.incrementAndGet();
        Connection noticeConn = this.noticeConnection.get();
        if (noticeConn == null && this.noticeConnection.compareAndSet(null, connection)) {
            connection.addNoticeListener(this);
        }
        if (numConn == this.targetNumConnections) {
            NoticeBean notice = this.createConnEstablishNotice();
            this.onNewEvent(new NoticeBean[]{notice});
        }
    }

    @Override
    public void onConnectionError(Connection connection, Throwable t) {
    }

    public synchronized void onNewEvent(final NoticeBean[] notices) {
        NoticeSaveTask noticeSaveTask = new NoticeSaveTask(this.dbMgr, this.subnet.getName(), notices);
        this.adapter.submitTask(noticeSaveTask, new ResultHandler<Void>(){

            @Override
            public void onTaskCompleted(Future<Void> saveResult) {
                try {
                    saveResult.get();
                    SubnetRequestDispatcher.this.fireNotices(notices);
                }
                catch (InterruptedException e) {
                    log.error("notice save task was interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    log.error("Exception caught during notice save task", e.getCause());
                }
            }
        });
    }

    @Override
    public void onFailoverProgress(ApplicationEvent event) {
        for (IFailoverEventListener iFailoverEventListener : this.snEventListeners) {
            try {
                iFailoverEventListener.onFailoverProgress(event);
            }
            catch (Exception e) {
                log.error("FailoverEventListener '{}' had an exception", (Object)iFailoverEventListener.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    @Override
    public SubnetDescription getSubnetDescription() {
        return this.subnet;
    }

    @Override
    public void refreshSubnetDescription(SubnetDescription subnet) {
        if (this.subnet.getSubnetId() == subnet.getSubnetId()) {
            this.subnet.setName(subnet.getName());
            this.subnet.setPrimaryFEIndex(subnet.getPrimaryFEIndex());
            HostInfo currFE = this.subnet.getCurrentFE();
            List<HostInfo> feList = subnet.getFEList();
            int currFEIdx = -1;
            IConnectionAssistant assistant = this.subnet.getConnectionAssistant();
            for (int i = 0; i < feList.size(); ++i) {
                HostInfo host = feList.get(i);
                host.setConnectionAssistant(assistant);
                if (!currFE.equals(host)) continue;
                currFEIdx = i;
            }
            this.subnet.setFEList(feList);
            if (currFEIdx >= 0) {
                this.subnet.setCurrentFEIndex(currFEIdx);
            } else {
                this.subnet.setCurrentFEIndex(subnet.getPrimaryFEIndex());
            }
        }
    }

    @Override
    public SSLEngine getSSLEngine(HostInfo hostInfo) throws Exception {
        SSLEngine engine = this.adapter.getSSLEngine(hostInfo);
        if (engine != null) {
            return engine;
        }
        IConnectionAssistant assistant = hostInfo.getConnectionAssistant();
        if (assistant == null) {
            assistant = new DefaultConnectionAssistant();
        }
        while (true) {
            try {
                CertsDescription certs = assistant.getSSLStoreCredentials(hostInfo);
                engine = this.adapter.getSSLEngine(hostInfo, certs);
                certs.clearPwds();
                return engine;
            }
            catch (SSLStoreCredentialsDeniedException e) {
                log.error("Connection prevented by user action", (Throwable)e);
                throw e;
            }
            catch (FMException e) {
                hostInfo.getCertsDescription().clearPwds();
                assistant.onSSLStoreError(e);
                continue;
            }
            catch (Exception e) {
                log.error("Error calling Connection Assistant", (Throwable)e);
                throw e;
            }
            break;
        }
    }

    private void processSelectedKeys() {
        Set<SelectionKey> keys = this.selector.selectedKeys();
        for (SelectionKey selKey : keys) {
            Connection conn = (Connection)selKey.attachment();
            if (conn.isProcessing()) continue;
            conn.setProcessing(true);
            try {
                int ops = selKey.interestOps();
                log.debug("Dispatching connection {}. InterestOps: {}", (Object)conn, (Object)ops);
                selKey.interestOps(0);
                conn.setInterestOps(ops);
                this.dispatch(conn);
            }
            catch (Exception e) {
                log.error("Exception processing selection key for connection {}", (Object)conn, (Object)e);
            }
        }
        keys.clear();
    }

    private void processPendingCmds() {
        while (!this.pendingCmds.isEmpty()) {
            PendingCommand pCmd = this.pendingCmds.poll();
            if (pCmd == null) continue;
            ICommand<?, ?> cmd = pCmd.getCommand();
            if (cmd.getResponse().isCancelled()) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Command {} with id '{}' has been cancelled by user. Ignored", cmd, (Object)cmd.getMessageID());
                continue;
            }
            Connection conn = pCmd.getConnection();
            try {
                if (conn == null) {
                    conn = this.poolingPolicy.nextHandler(this.connPool);
                }
                conn.assignCmd(cmd);
                SelectionKey selKey = conn.getSelectionKey();
                int ops = selKey.interestOps();
                selKey.interestOps(ops |= 4);
                if (!log.isDebugEnabled()) continue;
                log.debug("Command {} with id '{}' assigned to connection {}. InterestOps: {}", new Object[]{cmd, cmd.getMessageID(), conn, ops});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void processPendingResults() {
        while (!this.pendingResults.isEmpty()) {
            Reactor.HandlerTask result = this.pendingResults.poll();
            if (result == null) continue;
            this.processResult(result);
        }
    }

    private void processPendingConnections() {
        Connection initConn = null;
        Exception initException = null;
        while (!this.pendingConns.isEmpty()) {
            Connection conn = this.pendingConns.poll();
            this.connPool.add(conn);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Initializing connection to host {}...", (Object)conn.getHostInfo());
                }
                conn.initialize(this.selector, this);
            }
            catch (SSLStoreCredentialsDeniedException e) {
                this.connectionLost(e);
                this.pendingConns.clear();
                ArrayList cmds = new ArrayList();
                for (PendingCommand cmd : this.pendingCmds) {
                    cmds.add(cmd.getCommand());
                }
                this.cancelPendingCmds(cmds, e);
            }
            catch (Exception e) {
                initConn = conn;
                initException = e;
                ++this.invConnections;
            }
        }
        if (initException != null) {
            if (this.failoverInProgress) {
                throw new RuntimeException("Exception reconnecting to subnet " + this.subnet.getName() + " after failover", initException);
            }
            this.processConnectionError(this.createConnException(initException), initConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult(Reactor.HandlerTask result) {
        Connection conn = (Connection)result.getCallable();
        try {
            if (!conn.isClosing()) {
                result.get();
            }
        }
        catch (ExecutionException ee) {
            final Exception cause = (Exception)ee.getCause();
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    throw cause;
                }
            };
            try {
                callable.call();
            }
            catch (ClosedChannelException cce) {
                this.processConnectionError(this.createConnException(cce), conn);
            }
            catch (IOException ioe) {
                this.processIOException(ioe, conn);
            }
            catch (TimeoutException toe) {
                this.processConnectionError(this.createTimeoutException(toe), conn);
            }
            catch (Exception e) {
                this.processRequestError(e, conn);
            }
        }
        catch (Exception e) {
            log.error("Exception processing request handler", (Throwable)e);
        }
        finally {
            conn.setProcessing(false);
            SelectionKey selKey = conn.getSelectionKey();
            if (selKey != null && selKey.isValid()) {
                int ops = selKey.interestOps();
                int newops = conn.getInterestOps();
                ops = ops | newops | 1;
                selKey.interestOps(ops);
                log.debug("Processing for connection {} is complete. InterestOps: {}", (Object)conn, (Object)ops);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processConnectionError(Exception ce, Connection conn) {
        try {
            conn.close();
        }
        catch (IOException iOException) {
        }
        finally {
            if (!this.connectivityError) {
                this.failover(ce);
            }
        }
    }

    protected void processIOException(IOException ioe, Connection conn) {
        String msg = ioe.getMessage();
        if (ioe instanceof ConnectException || msg != null && msg.contains("connection was forcibly closed")) {
            log.error("Connection {} was forcibly closed", (Object)conn, (Object)ioe);
            this.processConnectionError(this.createConnException(ioe), conn);
        } else {
            this.processRequestError(ioe, conn);
        }
    }

    protected void processRequestError(final Exception re, final Connection conn) {
        log.error("Request error '{}' being handled by failure management", (Object)StringUtils.getErrorMessage(re));
        IFailureManagement failureMgr = this.adapter.getFailureManager();
        IFailureEvaluator failureEvaluator = this.adapter.getFailureEvaluator();
        BaseTaskFailure<Void> taskFailure = new BaseTaskFailure<Void>((Object)conn.getSelectionKey(), failureEvaluator){

            @Override
            public Callable<Void> getTask() {
                return null;
            }

            @Override
            public void onFatal() {
                log.info("Fatal Failure - Close connection!");
                SubnetRequestDispatcher.this.processConnectionError(re, conn);
            }
        };
        failureMgr.submit((ITaskFailure<Void>)taskFailure, re);
    }

    private RuntimeException createConnException(Exception e) {
        RuntimeException rte = new RuntimeException(STLMessages.STL20001_CONNECTION_ERROR.getDescription(this.subnet.getName(), StringUtils.getErrorMessage(e)), e);
        return rte;
    }

    private RuntimeException createTimeoutException(Exception e) {
        RuntimeException rte = new RuntimeException(STLMessages.STL20003_CONNECTION_TIMEOUT.getDescription(this.subnet.getName()));
        return rte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failover(Exception originalException) {
        log.info("Starting failover processing for subnet {}...", (Object)this.subnet.getName());
        this.fireFailoverStart();
        ArrayList pendingCmds = new ArrayList();
        Exception cause = null;
        try {
            this.failoverInProgress = true;
            IFailoverManager failoverMgr = this.adapter.getFailoverManager();
            long waitExtension = failoverMgr.getFailoverTimeout();
            this.resetConnections(pendingCmds, waitExtension);
            this.failoverMgrRunning = true;
            SubnetDescription modSubnet = failoverMgr.connectionLost(this.subnet, this);
            this.failoverMgrRunning = false;
            log.info("Failover completed; returned {}", (Object)modSubnet);
            this.subnet.setCurrentFEIndex(modSubnet.getCurrentFEIndex());
            this.setHostInfo();
            this.invConnections = 0;
            this.targetNumConnections = this.resizeConnectionPool();
            this.processPendingConnections();
            this.requeueCmds(pendingCmds);
            this.processPendingCmds();
        }
        catch (Exception e) {
            cause = e;
            log.error("Failover for subnet {} has thrown an exception: {}", new Object[]{this.subnet.getName(), e.getMessage(), e});
            this.connectionLost(originalException);
            this.cancelPendingCmds(pendingCmds, originalException);
        }
        finally {
            this.failoverMgrRunning = false;
            this.failoverInProgress = false;
            this.fireFailoverEnd(cause);
        }
    }

    private void connectionLost(Exception e) {
        this.connectivityError = true;
        this.connectivityException = e;
        NoticeBean notice = this.createConnLostNotice();
        this.onNewEvent(new NoticeBean[]{notice});
    }

    private void resetConnections(List<ICommand<?, ?>> cmds, long waitExtension) {
        Iterator<Connection> it = this.connPool.iterator();
        while (it.hasNext()) {
            Connection conn = it.next();
            Collection<ICommand<?, ?>> assignedCmds = conn.getPendingCommands();
            this.closeConnection(conn);
            it.remove();
            cmds.addAll(assignedCmds);
            for (ICommand<?, ?> cmd : assignedCmds) {
                cmd.getResponse().extendWaitTime(waitExtension);
            }
        }
        this.connPool.clear();
        this.connCompleted.set(0);
        this.noticeConnection.set(null);
    }

    protected void closeConnection(Connection conn) {
        block2: {
            try {
                conn.close();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Exception closing connection {}", (Object)conn, (Object)e);
            }
        }
    }

    protected void cancelPendingCmds(List<ICommand<?, ?>> cmds, Exception e) {
        for (ICommand<?, ?> cmd : cmds) {
            cmd.getResponse().setError(e);
        }
        while (!this.pendingCmds.isEmpty()) {
            ICommand<?, ?> cmd;
            PendingCommand pCmd = this.pendingCmds.poll();
            cmd = pCmd.getCommand();
            cmd.getResponse().setError(e);
        }
    }

    private void requeueCmds(List<ICommand<?, ?>> cmds) {
        for (ICommand<?, ?> cmd : cmds) {
            this.addPendingCommand(cmd, null);
        }
    }

    private void fireNotices(NoticeBean[] notices) {
        if (log.isDebugEnabled()) {
            log.debug("Fire {} notices: {} to {}", new Object[]{notices.length, Arrays.toString(notices), this.snEventListeners});
        }
        for (ISMEventListener listener : this.snEventListeners) {
            try {
                listener.onNewEvent(notices);
            }
            catch (Exception e) {
                log.error("SubnetEventListener '{}' had an exception", (Object)listener.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    protected void fireFailoverStart() {
        ApplicationEvent event = new ApplicationEvent(this.subnet);
        for (IFailoverEventListener iFailoverEventListener : this.snEventListeners) {
            try {
                iFailoverEventListener.onFailoverStart(event);
            }
            catch (Exception e) {
                log.error("FailoverEventListener '{}' had an exception", (Object)iFailoverEventListener.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    protected void fireFailoverEnd(Throwable result) {
        ApplicationEvent event = new ApplicationEvent(this.subnet, result);
        for (IFailoverEventListener iFailoverEventListener : this.snEventListeners) {
            try {
                iFailoverEventListener.onFailoverEnd(event);
            }
            catch (Exception e) {
                log.error("FailoverEventListener '{}' had an exception", (Object)iFailoverEventListener.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.running = false;
        super.shutdown();
        ArrayList<ISession> sessionList = new ArrayList<ISession>();
        List<ISession> list = this.sessions;
        synchronized (list) {
            Iterator<ISession> it = this.sessions.iterator();
            while (it.hasNext()) {
                sessionList.add(it.next());
            }
        }
        for (ISession session : sessionList) {
            session.close();
        }
        this.wakeupDispatcher();
    }

    private void closeConnections() {
        for (Connection conn : this.connPool) {
            try {
                conn.close();
            }
            catch (Exception e) {
                log.error("Exception closing connection {} during shutdown", (Object)conn, (Object)e);
            }
        }
    }

    private void setHostInfo() {
        List<HostInfo> feList = this.subnet.getFEList();
        if (feList == null || feList.size() == 0) {
            this.hostInfo = null;
        } else {
            HostInfo hostInfo = this.subnet.getCurrentFE();
            this.hostInfo = hostInfo.copy();
        }
    }

    private int resizeConnectionPool() {
        int numSessions = this.sessions.size();
        int connections = this.connPool.size() + this.pendingConns.size();
        int delta = this.poolingPolicy.calculateNumHandlers(connections, numSessions);
        if (delta > 0) {
            for (int i = 0; i < delta; ++i) {
                Connection conn = this.createConnection(this.hostInfo, this, false);
                this.addPendingConnection(conn);
            }
        }
        this.lastNumSessions = numSessions;
        return delta;
    }

    protected void wakeupDispatcher() {
        this.selector.wakeup();
    }

    protected void addPendingConnection(Connection conn) {
        this.pendingConns.add(conn);
    }

    protected void addPendingCommand(ICommand<?, ?> cmd, Connection conn) {
        cmd.setConnectionInProgress(true);
        PendingCommand pCmd = new PendingCommand(cmd, conn);
        this.pendingCmds.add(pCmd);
    }

    protected Connection createConnection(HostInfo host, IConnectionEventListener listener, boolean isTemporaryConnection) {
        if (host == null) {
            throw new IllegalArgumentException("Attempting to create a connection with null host");
        }
        SocketChannel channel = this.adapter.createChannel();
        Connection conn = host.isSecureConnect() ? new SecureConnection(host, channel, listener) : new Connection(host, channel, listener);
        conn.setTemporaryConnection(isTemporaryConnection);
        return conn;
    }

    private NoticeBean createConnEstablishNotice() {
        NoticeBean bean = new NoticeBean(true);
        GenericNoticeAttrBean attr = new GenericNoticeAttrBean();
        attr.setGeneric(true);
        attr.setType(NoticeType.INFO.getId());
        attr.setTrapNumber(TrapType.FE_CONNECTION_ESTABLISH.getId());
        bean.setAttributes(attr);
        bean.setData(new byte[0]);
        bean.setIssuerGID(new GIDGlobal());
        bean.setClassData(new byte[0]);
        return bean;
    }

    private NoticeBean createConnLostNotice() {
        NoticeBean bean = new NoticeBean(true);
        GenericNoticeAttrBean attr = new GenericNoticeAttrBean();
        attr.setGeneric(true);
        attr.setType(NoticeType.FATAL.getId());
        attr.setTrapNumber(TrapType.FE_CONNECTION_LOST.getId());
        bean.setAttributes(attr);
        bean.setData(new byte[0]);
        bean.setIssuerGID(new GIDGlobal());
        bean.setClassData(new byte[0]);
        return bean;
    }

    protected List<Connection> getConnectionPool() {
        return this.connPool;
    }

    protected IPoolingPolicy<Connection> getPoolingPolicy() {
        return this.poolingPolicy;
    }

    private class ConnectionTimeout
    extends Connection {
        private final TimeoutException toe;

        public ConnectionTimeout(TimeoutException toe) {
            super(null, null, null);
            this.toe = toe;
        }

        @Override
        public Void handle() throws Exception {
            throw this.toe;
        }
    }

    protected class PendingCommand {
        private final ICommand<?, ?> command;
        private final Connection connection;

        PendingCommand(ICommand<?, ?> cmd, Connection conn) {
            this.command = cmd;
            this.connection = conn;
        }

        public ICommand<?, ?> getCommand() {
            return this.command;
        }

        public Connection getConnection() {
            return this.connection;
        }
    }
}

