/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.fecdriver.ICommand;
import com.intel.stl.fecdriver.IResponse;
import com.intel.stl.fecdriver.adapter.IAdapter;
import com.intel.stl.fecdriver.dispatcher.Connection;
import com.intel.stl.fecdriver.dispatcher.IConnectionEventListener;
import com.intel.stl.fecdriver.dispatcher.ITempRequestDispatcher;
import com.intel.stl.fecdriver.dispatcher.NoPoolingPolicy;
import com.intel.stl.fecdriver.dispatcher.SubnetRequestDispatcher;
import com.intel.stl.fecdriver.session.ISession;
import com.intel.stl.fecdriver.session.TemporarySession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempRequestDispatcher
extends SubnetRequestDispatcher
implements ITempRequestDispatcher {
    private static Logger log = LoggerFactory.getLogger(TempRequestDispatcher.class);
    private static final String TEMP_SUBNET_NAME = "~tempconnections";

    public TempRequestDispatcher(IAdapter adapter) throws IOException {
        super(new SubnetDescription(TEMP_SUBNET_NAME), adapter, null, new NoPoolingPolicy());
    }

    @Override
    public ISession createTemporarySession(HostInfo host, IConnectionEventListener listener) {
        log.debug("Creating temporary session to host {}.", (Object)host);
        Connection conn = this.createConnection(host, listener, true);
        this.addPendingConnection(conn);
        TemporarySession tempSession = new TemporarySession(this, conn);
        this.sessions.add(tempSession);
        this.wakeupDispatcher();
        return tempSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(ISession session, Connection conn) {
        this.closeConnection(conn);
        List list = this.connPool;
        synchronized (list) {
            Iterator it = this.connPool.iterator();
            while (it.hasNext()) {
                if (!((Connection)it.next()).equals(conn)) continue;
                it.remove();
            }
        }
        super.removeSession(session);
    }

    @Override
    public <E extends IResponse<F>, F> void queueCmd(ICommand<E, F> cmd, Connection conn) {
        this.addPendingCommand(cmd, conn);
        this.wakeupDispatcher();
    }

    @Override
    protected void processConnectionError(Exception ce, Connection conn) {
        ArrayList cmds = new ArrayList();
        cmds.addAll(conn.getPendingCommands());
        this.closeConnection(conn);
        this.cancelPendingCmds(cmds, ce);
    }

    @Override
    protected void processRequestError(Exception re, Connection conn) {
    }
}

