/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter;

import com.intel.stl.fecdriver.messages.adapter.IDatagram;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SimpleDatagram<E>
implements IDatagram<E> {
    protected int length;
    protected ByteBuffer buffer;

    public SimpleDatagram(int length) {
        this.length = length;
    }

    @Override
    public int build(boolean force) {
        return this.build(force, ByteOrder.BIG_ENDIAN);
    }

    public int build(boolean force, ByteOrder order) {
        if (this.buffer == null || force) {
            this.buffer = ByteBuffer.allocate(this.length);
            this.buffer.order(order);
            this.initData();
            return this.buffer.capacity();
        }
        return 0;
    }

    protected void initData() {
        this.buffer.clear();
        this.buffer.put(new byte[this.buffer.capacity()]);
    }

    @Override
    public int wrap(byte[] data, int offset) {
        return this.wrap(data, offset, ByteOrder.BIG_ENDIAN);
    }

    public int wrap(byte[] data, int offset, ByteOrder order) {
        this.buffer = ByteBuffer.wrap(data, offset, this.length).slice();
        this.buffer.order(order);
        return offset + this.length;
    }

    @Override
    public boolean hasBuffer() {
        return this.buffer != null;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public ByteBuffer[] getByteBuffers() {
        if (this.buffer == null) {
            return null;
        }
        return new ByteBuffer[]{this.buffer};
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buffer.order();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void dump(String prefix, PrintStream out) {
        String formatted = this.format(prefix);
        out.print(formatted);
    }

    @Override
    public E toObject() {
        return null;
    }

    @Override
    public String toString(String prefix) {
        return this.format(prefix);
    }

    private String format(String prefix) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(prefix);
        strBuff.append(this.getClass().getSimpleName());
        strBuff.append("\n");
        if (this.buffer == null) {
            strBuff.append(prefix);
            strBuff.append("null");
            strBuff.append("\n");
            return strBuff.toString();
        }
        byte[] bytes = this.buffer.array();
        int offset = this.buffer.arrayOffset();
        strBuff.append(prefix);
        for (int i = 0; i < this.length; ++i) {
            strBuff.append(String.format("%02x", bytes[i + offset] & 0xFF) + " ");
            if ((i + 1) % 8 == 0) {
                strBuff.append(" ");
            }
            if ((i + 1) % 16 != 0) continue;
            strBuff.append("\n");
            if (i + 1 >= this.length) continue;
            strBuff.append(prefix);
        }
        if (this.length == 0 || this.length % 16 != 0) {
            strBuff.append("\n");
        }
        return strBuff.toString();
    }
}

