/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.subnet.GIDAsReg32s;
import com.intel.stl.api.subnet.GIDAsReg64s;
import com.intel.stl.api.subnet.GIDBean;
import com.intel.stl.api.subnet.GIDGlobal;
import com.intel.stl.api.subnet.GIDLinkLocal;
import com.intel.stl.api.subnet.GIDMulticast;
import com.intel.stl.api.subnet.GIDSiteLocal;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import java.nio.ByteOrder;

public abstract class GID<E extends GIDBean>
extends SimpleDatagram<E> {
    public GID() {
        super(16);
    }

    public static class Multicast
    extends GID<GIDMulticast> {
        public void setFormatPrefix(byte prefix) {
            short old = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getShort(0) : this.buffer.getShort(14);
            short value = (short)(prefix << 8 | old & 0xFF);
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putShort(0, value);
            } else {
                this.buffer.putShort(14, value);
            }
        }

        public byte getFormatPrefix() {
            short value = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getShort(0) : this.buffer.getShort(14);
            return (byte)(value >>> 8);
        }

        public void setFlags(byte flag) {
            short old = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getShort(0) : this.buffer.getShort(14);
            short value = (short)(old & 0xFF0F | flag << 4);
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putShort(0, value);
            } else {
                this.buffer.putShort(14, value);
            }
        }

        public byte getFlags() {
            short value = 0;
            value = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getShort(0) : this.buffer.getShort(14);
            return (byte)(value >>> 4 & 0xF);
        }

        public void setScope(byte scope) {
            short old = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getShort(0) : this.buffer.getShort(14);
            short value = (short)(old & 0xFFF0 | scope & 0xF);
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putShort(0, value);
            } else {
                this.buffer.putShort(14, value);
            }
        }

        public byte getScope() {
            short value = 0;
            value = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getShort(0) : this.buffer.getShort(14);
            return (byte)(value & 0xF);
        }

        public void setGroupId(byte[] bytes) {
            int pos = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? 14 : 0;
            this.buffer.position(pos);
            this.buffer.put(bytes, 0, 14);
        }

        public byte[] getGroupId() {
            byte[] res = new byte[14];
            int pos = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? 14 : 0;
            this.buffer.position(pos);
            this.buffer.get(res);
            return res;
        }

        @Override
        public GIDMulticast toObject() {
            GIDMulticast bean = new GIDMulticast(this.getFormatPrefix(), this.getFlags(), this.getScope(), this.getGroupId());
            return bean;
        }
    }

    public static class Global
    extends GID<GIDGlobal> {
        public Global() {
        }

        public Global(long interfaceId) {
            this.build(true);
            this.setInterfaceId(interfaceId);
        }

        public Global(long subnetPrefix, long interfaceId) {
            this.build(true);
            this.setSubnetPrefix(subnetPrefix);
            this.setInterfaceId(interfaceId);
        }

        public void setSubnetPrefix(long prefix) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(0, prefix);
            } else {
                this.buffer.putLong(8, prefix);
            }
        }

        public long getSubnetPrefix() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getLong(0);
            }
            return this.buffer.getLong(8);
        }

        public void setInterfaceId(long id) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(8, id);
            } else {
                this.buffer.putLong(0, id);
            }
        }

        public long getInterfaceId() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getLong(8);
            }
            return this.buffer.getLong(0);
        }

        @Override
        public GIDGlobal toObject() {
            GIDGlobal bean = new GIDGlobal(this.getSubnetPrefix(), this.getInterfaceId());
            return bean;
        }

        public String toString() {
            return "Global [getSubnetPrefix()=" + StringUtils.longHexString(this.getSubnetPrefix()) + ", getInterfaceId()=" + StringUtils.longHexString(this.getInterfaceId()) + "]";
        }
    }

    public static class SiteLocal
    extends GID<GIDSiteLocal> {
        public void setFormatPrefix(short prefix) {
            long old = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getLong(0) : this.buffer.getLong(8);
            long value = ((long)prefix & 0x3FFL) << 54 | old & 0xFFFFL;
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(0, value);
            } else {
                this.buffer.putLong(8, value);
            }
        }

        public short getFormatPrefix() {
            long value = 0L;
            value = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getLong(0) : this.buffer.getLong(8);
            return (short)(value >>> 54 & 0x3FFL);
        }

        public void setSubnetPrefix(short prefix) {
            long old = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getLong(0) : this.buffer.getLong(8);
            long value = old & 0xFFC0000000000000L | (long)prefix & 0xFFFFL;
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(0, value);
            } else {
                this.buffer.putLong(8, value);
            }
        }

        public short getSubnetPrefix() {
            long value = 0L;
            value = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getLong(0) : this.buffer.getLong(8);
            return (short)(value & 0xFFFFL);
        }

        public void setInterfaceId(long id) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(8, id);
            } else {
                this.buffer.putLong(0, id);
            }
        }

        public long getInterfaceId() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getLong(8);
            }
            return this.buffer.getLong(0);
        }

        @Override
        public GIDSiteLocal toObject() {
            GIDSiteLocal bean = new GIDSiteLocal(this.getFormatPrefix(), this.getSubnetPrefix(), this.getInterfaceId());
            return bean;
        }
    }

    public static class LinkLocal
    extends GID<GIDLinkLocal> {
        public void setFormatPrefix(short prefix) {
            long value = ((long)prefix & 0x3FFL) << 54;
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(0, value);
            } else {
                this.buffer.putLong(8, value);
            }
        }

        public short getFormatPrefix() {
            long value = 0L;
            value = this.getByteOrder() == ByteOrder.BIG_ENDIAN ? this.buffer.getLong(0) : this.buffer.getLong(8);
            return (short)(value >>> 54 & 0x3FFL);
        }

        public void setInterfaceId(long id) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(8, id);
            } else {
                this.buffer.putLong(0, id);
            }
        }

        public long getInterfaceId() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getLong(8);
            }
            return this.buffer.getLong(0);
        }

        @Override
        public GIDLinkLocal toObject() {
            GIDLinkLocal bean = new GIDLinkLocal(this.getFormatPrefix(), this.getInterfaceId());
            return bean;
        }
    }

    public static class AsReg64s
    extends GID<GIDAsReg64s> {
        public void setH(long h) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(0, h);
            } else {
                this.buffer.putLong(8, h);
            }
        }

        public long getH() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getLong(0);
            }
            return this.buffer.getLong(8);
        }

        public void setL(long l) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putLong(8, l);
            } else {
                this.buffer.putLong(0, l);
            }
        }

        public long getL() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getLong(8);
            }
            return this.buffer.getLong(0);
        }

        @Override
        public GIDAsReg64s toObject() {
            GIDAsReg64s bean = new GIDAsReg64s(this.getH(), this.getL());
            return bean;
        }
    }

    public static class AsReg32s
    extends GID<GIDAsReg32s> {
        public void setHH(int hh) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putInt(0, hh);
            } else {
                this.buffer.putInt(12, hh);
            }
        }

        public int getHH() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getInt(0);
            }
            return this.buffer.getInt(12);
        }

        public void setHL(int hl) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putInt(4, hl);
            } else {
                this.buffer.putInt(8, hl);
            }
        }

        public int getHL() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getInt(4);
            }
            return this.buffer.getInt(8);
        }

        public void setLH(int lh) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putInt(8, lh);
            } else {
                this.buffer.putInt(4, lh);
            }
        }

        public int getLH() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getInt(8);
            }
            return this.buffer.getInt(4);
        }

        public void setLL(int ll) {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putInt(12, ll);
            } else {
                this.buffer.putInt(0, ll);
            }
        }

        public int getLL() {
            if (this.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                return this.buffer.getInt(12);
            }
            return this.buffer.getInt(0);
        }

        @Override
        public GIDAsReg32s toObject() {
            GIDAsReg32s bean = new GIDAsReg32s(this.getHH(), this.getHL(), this.getLH(), this.getLL());
            return bean;
        }
    }
}

