/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.MFTRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class MFTRecord
extends SimpleDatagram<MFTRecordBean> {
    public MFTRecord() {
        super(72);
    }

    public void setLID(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setPosition(byte position) {
        int oldVal = this.buffer.getInt(4);
        int val = oldVal & 0x1FFFFF | position << 30;
        this.buffer.putInt(4, val);
    }

    public void setBlockNum(int num) {
        int oldVal = this.buffer.getInt(4);
        int val = oldVal & 0xC0000000 | num & 0x1FFFFF;
        this.buffer.putInt(4, val);
    }

    public void setMftTable(long[] data) {
        if (data.length != 8) {
            throw new IllegalArgumentException("Invalid data length. Expect 8, got " + data.length);
        }
        this.buffer.position(8);
        for (long val : data) {
            this.buffer.putLong(val);
        }
    }

    @Override
    public MFTRecordBean toObject() {
        this.buffer.clear();
        int lid = this.buffer.getInt();
        int intVal = this.buffer.getInt();
        byte position = (byte)(intVal >>> 30);
        int blockNum = intVal & 0x1FFFFF;
        MFTRecordBean bean = new MFTRecordBean(lid, position, blockNum);
        long[] data = new long[8];
        for (int i = 0; i < 8; ++i) {
            data[i] = this.buffer.getLong();
        }
        bean.setMftTable(data);
        return bean;
    }
}

