/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.P_KeyTableBean;
import com.intel.stl.api.subnet.P_KeyTableRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class PKeyTableRecord
extends SimpleDatagram<P_KeyTableRecordBean> {
    public PKeyTableRecord() {
        super(72);
    }

    public void setLID(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setBlockNum(short num) {
        this.buffer.putShort(4, num);
    }

    public void setPortNum(byte num) {
        this.buffer.put(6, num);
    }

    public void setPKeyTableData(short[] data) {
        if (data.length != 32) {
            throw new IllegalArgumentException("Invalid data length. Expect 32,  got " + data.length + ".");
        }
        this.buffer.position(8);
        for (int i = 0; i < 32; ++i) {
            this.buffer.putShort(data[i]);
        }
    }

    @Override
    public P_KeyTableRecordBean toObject() {
        this.buffer.clear();
        int lid = this.buffer.getInt();
        short blockNum = this.buffer.getShort();
        byte portNum = this.buffer.get();
        this.buffer.position(8);
        P_KeyTableBean[] pKeyTableData = new P_KeyTableBean[32];
        for (int i = 0; i < 32; ++i) {
            short val = this.buffer.getShort();
            pKeyTableData[i] = new P_KeyTableBean((val & 0x8000) == 32768, (short)(val & Short.MAX_VALUE));
        }
        P_KeyTableRecordBean bean = new P_KeyTableRecordBean(lid, blockNum, portNum, pKeyTableData);
        return bean;
    }
}

