/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.GIDBean;
import com.intel.stl.api.subnet.PathRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import com.intel.stl.fecdriver.messages.adapter.sa.GID;

public class PathRecord
extends SimpleDatagram<PathRecordBean> {
    private GID<?> sGid;
    private GID<?> dGid;

    public PathRecord() {
        super(64);
    }

    public void setServiceId(long id) {
        this.buffer.putLong(0, id);
    }

    public void setDGID(GID<?> gid) {
        this.dGid = gid;
        this.buffer.position(8);
        this.buffer.put(gid.getByteBuffer().array(), gid.getByteBuffer().arrayOffset(), gid.getLength());
    }

    public GID<?> getDGid() {
        if (this.dGid == null) {
            this.dGid = new GID.Global();
            this.dGid.wrap(this.buffer.array(), this.buffer.arrayOffset() + 8);
        }
        return this.dGid;
    }

    public void setSGID(GID<?> gid) {
        this.sGid = gid;
        this.buffer.position(24);
        this.buffer.put(gid.getByteBuffer().array(), gid.getByteBuffer().arrayOffset(), gid.getLength());
    }

    public GID<?> getSGid() {
        if (this.sGid == null) {
            this.sGid = new GID.Global();
            this.sGid.wrap(this.buffer.array(), this.buffer.arrayOffset() + 24);
        }
        return this.sGid;
    }

    public void setDLidLow(short lid) {
        this.buffer.putShort(40, lid);
    }

    public void setSLidLow(short lid) {
        this.buffer.putShort(42, lid);
    }

    public void setGRH(int value) {
        this.buffer.putInt(44, value);
    }

    public void setTClass(byte tClass) {
        this.buffer.put(48, tClass);
    }

    public void setReversible(boolean b) {
        byte old = this.buffer.get(49);
        int value = b ? old | 0x80 : old & 0x7F;
        this.buffer.put(49, (byte)value);
    }

    public void setNumPath(byte num) {
        byte old = this.buffer.get(49);
        int value = old & 0x80 | num & 0x7F;
        this.buffer.put(49, (byte)value);
    }

    public void setPKey(short key) {
        this.buffer.putShort(50, key);
    }

    public void setQosType(byte type) {
        short old = this.buffer.getShort(52);
        int value = (type & 3) << 14 | old & 0x3FFF;
        this.buffer.putShort(52, (byte)value);
    }

    public void setQosPriority(byte priority) {
        short old = this.buffer.getShort(52);
        int value = priority << 4 | old & 0xF00F;
        this.buffer.putShort(52, (byte)value);
    }

    public void setSL(byte sl) {
        short old = this.buffer.getShort(52);
        int value = sl & 0xF | old & 0xFFF0;
        this.buffer.putShort(52, (byte)value);
    }

    public void setMtu(byte value) {
        this.buffer.put(54, value);
    }

    public void setRate(byte value) {
        this.buffer.put(55, value);
    }

    public void setPktLifeTime(byte value) {
        this.buffer.put(56, value);
    }

    public void setPreference(byte preference) {
        this.buffer.put(57, preference);
    }

    @Override
    public PathRecordBean toObject() {
        this.buffer.clear();
        PathRecordBean bean = new PathRecordBean();
        bean.setServiceId(this.buffer.getLong());
        bean.setDGid((GIDBean)this.getDGid().toObject());
        bean.setSGid((GIDBean)this.getSGid().toObject());
        this.buffer.position(40);
        bean.setDLid(this.buffer.getShort());
        bean.setSLid(this.buffer.getShort());
        int intVal = this.buffer.getInt();
        bean.setRawTraffic((intVal & Integer.MIN_VALUE) == Integer.MIN_VALUE);
        bean.setFlowLabel(intVal >>> 8 & 0xFFFFF);
        bean.setHopLimit((byte)(intVal & 0xFF));
        bean.setTClass(this.buffer.get());
        byte byteVal = this.buffer.get();
        bean.setReversible((byteVal & 0x80) == 128);
        bean.setNumbPath((byte)(byteVal & 0x7F));
        bean.setPKey(this.buffer.getShort());
        short shortVal = this.buffer.getShort();
        bean.setQosType((byte)(shortVal >>> 14 & 3));
        bean.setQosPriority((byte)(shortVal >>> 4 & 0xF));
        bean.setSL((byte)(shortVal & 0xF));
        byteVal = this.buffer.get();
        bean.setMtuSelector((byte)(byteVal >>> 6 & 3));
        bean.setMtu((byte)(byteVal & 0x3F));
        byteVal = this.buffer.get();
        bean.setRateSelector((byte)(byteVal >>> 6 & 3));
        bean.setRate((byte)(byteVal & 0x3F));
        byteVal = this.buffer.get();
        bean.setPktLifeTimeSelector((byte)(byteVal >>> 6 & 3));
        bean.setPktLifeTime((byte)(byteVal & 0x3F));
        bean.setPreference(this.buffer.get());
        return bean;
    }
}

