/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.PortInfoBean;
import com.intel.stl.api.subnet.PortStatesBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import com.intel.stl.fecdriver.messages.adapter.sa.FlitControl;
import com.intel.stl.fecdriver.messages.adapter.sa.VirtualLane;
import java.nio.ByteOrder;

public class PortInfo
extends SimpleDatagram<PortInfoBean> {
    private VirtualLane virtualLane = null;
    private FlitControl flitControl = null;

    public PortInfo() {
        super(242);
    }

    @Override
    public int build(boolean force, ByteOrder order) {
        int res = super.build(force, order);
        this.virtualLane = new VirtualLane();
        byte[] bytes = this.buffer.array();
        this.virtualLane.wrap(bytes, this.buffer.arrayOffset() + 8, order);
        this.flitControl = new FlitControl();
        this.flitControl.wrap(bytes, 78, order);
        return res;
    }

    @Override
    public int wrap(byte[] data, int offset, ByteOrder order) {
        int res = super.wrap(data, offset, order);
        this.virtualLane = new VirtualLane();
        this.virtualLane.wrap(data, offset + 8, order);
        this.flitControl = new FlitControl();
        this.flitControl.wrap(data, offset + 78, order);
        return res;
    }

    public void setLid(int lid) {
        this.buffer.putInt(0, lid);
    }

    @Override
    public PortInfoBean toObject() {
        this.buffer.clear();
        PortInfoBean bean = new PortInfoBean();
        bean.setLid(this.buffer.getInt());
        bean.setFlowControlMask(this.buffer.getInt());
        bean.setVl(this.virtualLane.toObject());
        this.buffer.position(16);
        int intVal = this.buffer.getInt();
        PortStatesBean psb = new PortStatesBean((intVal & 0x400000) == 0x400000, (intVal & 0x200000) == 0x200000, (intVal & 0x100000) == 0x100000, (byte)(intVal >>> 16 & 0xF), (byte)(intVal >>> 4 & 0xF), (byte)(intVal & 0xF));
        bean.setPortStates(psb);
        bean.setPortType((byte)(this.buffer.get() & 0xF));
        byte byteVal = this.buffer.get();
        bean.setCollectiveMask((byte)(byteVal >>> 3 & 7));
        bean.setMulticastMask((byte)(byteVal & 7));
        byteVal = this.buffer.get();
        bean.setMKeyProtectBits((byte)(byteVal >>> 6 & 3));
        bean.setLmc((byte)(byteVal & 0xF));
        byteVal = this.buffer.get();
        bean.setMasterSMSL((byte)(byteVal & 0x1F));
        byteVal = this.buffer.get();
        bean.setLinkInitReason((byte)(byteVal >>> 4 & 0xF));
        bean.setPartitionEnforcementInbound((byteVal & 8) == 8);
        bean.setPartitionEnforcementOutbound((byteVal & 4) == 4);
        byteVal = this.buffer.get();
        bean.setOperationalVL((byte)(byteVal & 0x1F));
        bean.setPKey8B(this.buffer.getShort());
        bean.setPKey10B(this.buffer.getShort());
        bean.setMKeyViolation(this.buffer.getShort());
        bean.setPKeyViolation(this.buffer.getShort());
        bean.setQKeyViolation(this.buffer.getShort());
        intVal = this.buffer.getInt();
        bean.setSmTrapQueuePair(intVal & 0xFFFFFF);
        intVal = this.buffer.getInt();
        bean.setSaQueuePair(intVal & 0xFFFFFF);
        bean.setNeighborPortNum(this.buffer.get());
        bean.setLinkDownReason(this.buffer.get());
        bean.setNeighborLinkDownReason(this.buffer.get());
        byteVal = this.buffer.get();
        bean.setClientReregister((byteVal & 0x80) == 128);
        bean.setMulPKeyTrapSuppressionEnabled((byte)(byteVal >>> 5 & 3));
        bean.setSubnetTimeout((byte)(byteVal & 0x1F));
        bean.setLinkSpeedSupported(this.buffer.getShort());
        bean.setLinkSpeedEnabled(this.buffer.getShort());
        bean.setLinkSpeedActive(this.buffer.getShort());
        bean.setLinkWidthSupported(this.buffer.getShort());
        bean.setLinkWidthEnabled(this.buffer.getShort());
        bean.setLinkWidthActive(this.buffer.getShort());
        bean.setLinkWidthDownSupported(this.buffer.getShort());
        bean.setLinkWidthDownEnabled(this.buffer.getShort());
        bean.setLinkWidthDownTxActive(this.buffer.getShort());
        bean.setLinkWidthDownRxActive(this.buffer.getShort());
        this.buffer.position(68);
        short shortVal = this.buffer.getShort();
        bean.setPlmSupported((byte)(shortVal >>> 10 & 0x1F));
        bean.setPlmEnabled((byte)(shortVal >>> 5 & 0x1F));
        bean.setPlmActive((byte)(shortVal & 0x1F));
        shortVal = this.buffer.getShort();
        bean.setPLTPCRCModeSupported((byte)(shortVal >>> 8 & 0xF));
        bean.setPLTPCRCModeEnabled((byte)(shortVal >>> 4 & 0xF));
        bean.setPLTPCRCModeActive((byte)(shortVal & 0xF));
        shortVal = this.buffer.getShort();
        bean.setActiveOptimizeEnabled((shortVal & 0x40) == 64);
        bean.setPassThroughEnabled((shortVal & 0x20) == 32);
        bean.setVLMarkerEnabled((shortVal & 0x10) == 16);
        bean.set16BTrapQueryEnabled((shortVal & 2) == 2);
        bean.setPpfSupported(this.buffer.getShort());
        bean.setPpfEnabled(this.buffer.getShort());
        bean.setFlitControl(this.flitControl.toObject());
        this.buffer.position(92);
        bean.setPortErrorAction(this.buffer.getInt());
        bean.setEgressPort(this.buffer.get());
        bean.setDrControl((this.buffer.get() & 1) == 1);
        bean.setMKeyLeasePeriod(this.buffer.getShort());
        intVal = this.buffer.getInt();
        bean.setVl15Init((short)(intVal >>> 11 & 0xFFF));
        bean.setVl15CreditRate((byte)(intVal >>> 6 & 0x1F));
        bean.setCreditAck((byte)(intVal >>> 3 & 7));
        bean.setBufferAlloc((byte)(intVal & 0x1F));
        this.buffer.position(108);
        bean.setMasterSMLID(this.buffer.getInt());
        bean.setMKey(this.buffer.getLong());
        bean.setSubnetPrefix(this.buffer.getLong());
        byte[] byteVals = new byte[16];
        this.buffer.get(byteVals);
        byte[] vl0MTU = new byte[byteVals.length];
        byte[] vl1MTU = new byte[byteVals.length];
        for (int i = 0; i < byteVals.length; ++i) {
            vl0MTU[i] = (byte)(byteVals[i] >>> 4 & 0xF);
            vl1MTU[i] = (byte)(byteVals[i] & 0xF);
        }
        bean.setNeighborVL0MTU(vl0MTU);
        bean.setNeighborVL1MTU(vl1MTU);
        byteVals = new byte[32];
        this.buffer.get(byteVals);
        byte[] vlStallCounts = new byte[32];
        byte[] hoqLifes = new byte[32];
        for (int i = 0; i < byteVals.length; ++i) {
            vlStallCounts[i] = (byte)(byteVals[i] >>> 5 & 7);
            hoqLifes[i] = (byte)(byteVals[i] & 0x1F);
        }
        bean.setVlStallCount(vlStallCounts);
        bean.setHoqLife(hoqLifes);
        byteVals = new byte[16];
        this.buffer.get(byteVals);
        bean.setIpAddrIPV6(byteVals);
        byteVals = new byte[4];
        this.buffer.get(byteVals);
        bean.setIpAddrIPV4(byteVals);
        this.buffer.position(208);
        bean.setNeighborNodeGUID(this.buffer.getLong());
        bean.setCapabilityMask(this.buffer.getInt());
        this.buffer.position(222);
        bean.setCapabilityMask3(this.buffer.getShort());
        this.buffer.position(228);
        bean.setOverallBufferSpace(this.buffer.getShort());
        this.buffer.position(232);
        shortVal = this.buffer.getShort();
        bean.setUniversalDiagCode((byte)(shortVal >>> 12 & 0xF));
        bean.setVendorDiagCode((short)(shortVal >>> 1 & 0x7FF));
        bean.setChain((shortVal & 1) == 1);
        bean.setBufferDepth(this.buffer.get());
        bean.setWireDepth(this.buffer.get());
        byteVal = this.buffer.get();
        bean.setMgmtAllowed((byteVal & 8) == 8);
        bean.setNeighborFWAuthenBypass((byteVal & 4) == 4);
        bean.setNeighborNodeType((byte)(byteVal & 3));
        byteVal = this.buffer.get();
        bean.setMtuCap((byte)(byteVal & 0xF));
        byteVal = this.buffer.get();
        bean.setRespTimeValue((byte)(byteVal & 0x1F));
        bean.setLocalPortNum(this.buffer.get());
        return bean;
    }
}

