/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.SwitchInfoBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class SwitchInfo
extends SimpleDatagram<SwitchInfoBean> {
    public SwitchInfo() {
        super(84);
    }

    public void setLinearFDBCap(int cap) {
        this.buffer.putInt(0, cap);
    }

    public void setPortGroupFDBCap(int cap) {
        this.buffer.putInt(4, cap);
    }

    public void setMulticastFDBCap(int cap) {
        this.buffer.putInt(8, cap);
    }

    public void setLinearFDBTop(int top) {
        this.buffer.putInt(12, top);
    }

    public void setMulticastFDBTop(int top) {
        this.buffer.putInt(16, top);
    }

    public void setCollectiveCap(int cap) {
        this.buffer.putInt(20, cap);
    }

    public void setCollectiveTop(int top) {
        this.buffer.putInt(24, top);
    }

    public void setIPAddrIPV6(byte[] ip) {
        if (ip.length != 16) {
            throw new IllegalArgumentException("Invalid data length. Expect 16, got " + ip.length + ".");
        }
        this.buffer.position(32);
        this.buffer.put(ip);
    }

    public void setIPAddrIPV4(byte[] ip) {
        if (ip.length != 4) {
            throw new IllegalArgumentException("Invalid data length. Expect 4, got " + ip.length + ".");
        }
        this.buffer.position(48);
        this.buffer.put(ip);
    }

    public void setDefaultPort(byte port) {
        this.buffer.put(64, port);
    }

    public void setDefaultMulticastPrimaryPort(byte port) {
        this.buffer.put(65, port);
    }

    public void setDefaultMulticastNotPrimaryPort(byte port) {
        this.buffer.put(66, port);
    }

    public void setU1(byte value) {
        this.buffer.put(67, value);
    }

    public void setLIDsPerPort(short num) {
        this.buffer.putShort(68, num);
    }

    public void setPartitionEnforcementCap(short cap) {
        this.buffer.putShort(70, cap);
    }

    public void setSupportedRoutingMode(byte mode) {
        this.buffer.put(74, mode);
    }

    public void setEnabledRoutingMode(byte mode) {
        this.buffer.put(75, mode);
    }

    public void setCapabilities(byte capabilities) {
        this.buffer.put(76, capabilities);
    }

    public void setMultiCollectMask(byte mask) {
        this.buffer.put(77, mask);
    }

    public void setAdaptiveRouting(byte value) {
        this.buffer.put(78, value);
    }

    public void setCapabilityMask(short mask) {
        this.buffer.putShort(80, mask);
    }

    public void setCapabilityMaskCollectives(short value) {
        this.buffer.putShort(82, value);
    }

    @Override
    public SwitchInfoBean toObject() {
        this.buffer.clear();
        SwitchInfoBean bean = new SwitchInfoBean();
        bean.setLinearFDBCap(this.buffer.getInt());
        bean.setPortGroupFDBCap(this.buffer.getInt());
        bean.setMulticastFDBCap(this.buffer.getInt());
        bean.setLinearFDBTop(this.buffer.getInt());
        bean.setMulticastFDBTop(this.buffer.getInt());
        bean.setCollectiveCap(this.buffer.getInt());
        bean.setCollectiveTop(this.buffer.getInt());
        this.buffer.getInt();
        byte[] byteVals = new byte[16];
        this.buffer.get(byteVals);
        bean.setIpAddrIPV6(byteVals);
        byteVals = new byte[4];
        this.buffer.get(byteVals);
        bean.setIpAddrIPV4(byteVals);
        this.buffer.getInt();
        this.buffer.getInt();
        this.buffer.getInt();
        this.buffer.get();
        this.buffer.get();
        this.buffer.get();
        byte byteVal = this.buffer.get();
        bean.setLifeTimeValue((byte)(byteVal >> 3 & 0x1F));
        bean.setPortStateChange((byteVal & 4) == 4);
        this.buffer.getShort();
        bean.setPartitionEnforcementCap(this.buffer.getShort());
        bean.setPortGroupCap(this.buffer.get());
        bean.setPortGroupTop(this.buffer.get());
        bean.setRoutingModeSupported(this.buffer.get());
        bean.setRoutingModeEnabled(this.buffer.get());
        byteVal = this.buffer.get();
        bean.setEnhancedPort0((byteVal & 8) == 8);
        byteVal = this.buffer.get();
        bean.setCollectiveMask((byte)(byteVal >>> 3 & 7));
        bean.setMulticastMask((byte)(byteVal & 7));
        short shortVal = this.buffer.getShort();
        bean.setAdaptiveRoutingEnable((shortVal & 0x8000) == 32768);
        bean.setAdaptiveRoutingPause((shortVal & 0x4000) == 16384);
        bean.setAdaptiveRoutingAlgorithm((byte)(shortVal >>> 11 & 7));
        bean.setAdaptiveRoutingFrequency((byte)(shortVal >>> 8 & 7));
        bean.setAdaptiveRoutingLostRoutesOnly((shortVal & 0x80) == 128);
        bean.setAdaptiveRoutingThreshold((byte)(shortVal >>> 4 & 7));
        shortVal = this.buffer.getShort();
        bean.setAddrRangeConfigSupported((shortVal & 4) == 4);
        bean.setAdaptiveRoutingSupported((shortVal & 1) == 1);
        shortVal = this.buffer.getShort();
        bean.setCapabilityMaskCollectives(shortVal);
        return bean;
    }
}

