/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.response;

import com.intel.stl.api.MadException;
import com.intel.stl.fecdriver.IResponse;
import com.intel.stl.fecdriver.messages.adapter.IDatagram;
import com.intel.stl.fecdriver.messages.adapter.RmppMad;
import com.intel.stl.fecdriver.messages.command.FVMessage;
import com.intel.stl.fecdriver.session.RequestCancelledByUserException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class FVResponse<E>
extends FVMessage
implements IResponse<E> {
    private String description;
    private RmppMad rmppMad;
    private Exception error;
    private boolean canceled;
    private List<E> results;
    private long expireTime;
    private boolean connectionInProgress = false;
    private boolean oneMoreTime = false;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    protected void setResults(List<E> results) {
        this.results = results;
    }

    @Override
    public synchronized void setError(Exception e) {
        this.error = e;
        this.notify();
    }

    @Override
    public synchronized Exception getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void processMad(RmppMad mad) {
        try {
            ByteBuffer buffer = mad.getData().getByteBuffers()[0];
            byte[] bytes = buffer.array();
            int offset = buffer.arrayOffset();
            IDatagram<?> datagram = this.wrap(bytes, offset, offset + buffer.limit());
            mad.setData(datagram);
            this.rmppMad = mad;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = e;
        }
        finally {
            this.notify();
        }
    }

    public RmppMad getMad() throws IOException {
        if (this.error != null) {
            throw new IOException(this.error);
        }
        return this.rmppMad;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        this.setCancel();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.rmppMad != null || this.error != null || this.canceled;
    }

    @Override
    public List<E> get() throws IOException {
        if (!this.isDone()) {
            this.waitForResponse();
        }
        return this.results;
    }

    @Override
    public List<E> get(long timeout, TimeUnit unit) throws IOException, TimeoutException {
        if (!this.isDone()) {
            this.waitForResponse(unit.toMillis(timeout));
        }
        return this.results;
    }

    @Override
    public void extendWaitTime(long waitExtension) {
        long current = System.currentTimeMillis();
        this.expireTime = current + waitExtension;
    }

    public synchronized void setConnectionInProgress(boolean inProgress) {
        this.connectionInProgress = inProgress;
        if (inProgress) {
            this.oneMoreTime = true;
        }
        this.notify();
    }

    protected synchronized void waitForResponse(long timeoutInMs) throws IOException, TimeoutException {
        long current = System.currentTimeMillis();
        this.expireTime = current + timeoutInMs;
        while (!this.isDone() && current < this.expireTime) {
            try {
                this.wait(this.expireTime - current);
                current = System.currentTimeMillis();
                if (this.isDone()) continue;
                if (this.connectionInProgress) {
                    this.expireTime = current + timeoutInMs;
                    continue;
                }
                if (!this.oneMoreTime) continue;
                this.oneMoreTime = false;
                this.expireTime = current + timeoutInMs;
            }
            catch (InterruptedException e) {
                this.setCancel();
                break;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.checkError();
        if (current >= this.expireTime) {
            throw new TimeoutException();
        }
    }

    protected synchronized void waitForResponse() throws IOException {
        while (!this.isDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.setCancel();
                break;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.checkError();
    }

    private void checkError() throws IOException {
        if (this.error != null && !(this.error instanceof MadException)) {
            if (this.error instanceof IOException) {
                IOException ioe = (IOException)this.error;
                throw ioe;
            }
            if (this.error instanceof RuntimeException) {
                RuntimeException rte = (RuntimeException)this.error;
                throw rte;
            }
            throw new IOException(this.error);
        }
    }

    protected IDatagram<?> wrap(byte[] data, int offset, int totalLength) {
        throw new UnsupportedOperationException();
    }

    private void setCancel() {
        this.error = new RequestCancelledByUserException();
        this.canceled = true;
    }

    public void dump(PrintStream out) {
        try {
            this.getMad().dump("", out);
            this.dumpResults(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dumpResults(PrintStream out) {
        try {
            List<E> results = this.get();
            if (results == null) {
                out.println("null");
            } else {
                for (int i = 0; i < results.size(); ++i) {
                    out.println(i + " " + results.get(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

