/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.network.ssh.impl;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSession;
import com.jcraft.jsch.JSchException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSchSessionFactory {
    private static final Logger log = LoggerFactory.getLogger(JSchSessionFactory.class);
    private static final Map<String, JSchSession> sessionMap = new HashMap<String, JSchSession>();

    public static synchronized JSchSession getSession(SubnetDescription subnet, boolean strictHostKey, char[] password, String sshKey) throws JSchException {
        JSchSession jschSession = sessionMap.get(sshKey);
        if (jschSession != null && !jschSession.isConnected()) {
            JSchSessionFactory.closeSession(sshKey);
            sessionMap.remove(sshKey);
            jschSession = null;
        }
        if (jschSession == null) {
            jschSession = JSchSessionFactory.createSession(subnet, strictHostKey, password, sshKey);
        }
        return jschSession;
    }

    public static JSchSession getSessionFromMap(String sshKey) {
        return sessionMap.get(sshKey);
    }

    protected static JSchSession createSession(SubnetDescription subnet, boolean strictHostKey, char[] password, String sshKey) throws JSchException {
        JSchSession jschSession = null;
        try {
            jschSession = new JSchSession(subnet, strictHostKey, password, sshKey);
            if (jschSession == null || !jschSession.isConnected()) {
                throw new JSchException(STLMessages.STL50015_SESSION_CONNECTION_FAILURE.getDescription());
            }
            sessionMap.put(sshKey, jschSession);
        }
        catch (JSchException e) {
            if (jschSession != null) {
                jschSession.shutdown();
            }
            throw e;
        }
        return jschSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession(String sshKey) {
        JSchSession jschSession = sessionMap.get(sshKey);
        if (jschSession != null) {
            try {
                jschSession.shutdown();
            }
            finally {
                sessionMap.remove(sshKey);
            }
        }
    }

    public static void cleanup() {
        for (JSchSession session : sessionMap.values()) {
            session.shutdown();
        }
    }
}

