/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl;

import com.intel.stl.ui.admin.FunctionType;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.UndoableTabSelection;
import com.intel.stl.ui.admin.impl.AbstractEditorController;
import com.intel.stl.ui.admin.impl.ConfPageController;
import com.intel.stl.ui.admin.impl.SMLogModel;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.impl.applications.AppsPageController;
import com.intel.stl.ui.admin.impl.devicegroups.DevicegroupsPageController;
import com.intel.stl.ui.admin.impl.logs.LogPage;
import com.intel.stl.ui.admin.impl.logs.SMLogController;
import com.intel.stl.ui.admin.impl.virtualfabrics.VirtualFabricsPageController;
import com.intel.stl.ui.admin.view.AbstractConfView;
import com.intel.stl.ui.admin.view.AdminView;
import com.intel.stl.ui.admin.view.BlankView;
import com.intel.stl.ui.admin.view.NavigationPanel;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.admin.view.applications.AppsSubpageView;
import com.intel.stl.ui.admin.view.devicegroups.DevicegroupsSubpageView;
import com.intel.stl.ui.admin.view.logs.SMLogView;
import com.intel.stl.ui.admin.view.virtualfabrics.VirtualFabricsSubpageView;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.console.ConsoleDispatchManager;
import com.intel.stl.ui.console.ConsolePage;
import com.intel.stl.ui.console.view.ConsoleView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.UndoHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.engio.mbassy.bus.MBassador;

public class AdminPage
implements IPageController,
ChangeListener {
    public static final String NAME = STLConstants.K1057_ADMIN.getValue();
    private final AdminView view;
    private final List<IPageController> subpages;
    private IPageController currentPage;
    private final MBassador<IAppEvent> eventBus;
    private boolean isShowing;
    protected UndoHandler undoHandler;

    public AdminPage(AdminView view, MBassador<IAppEvent> eventBus) {
        this.view = view;
        view.addChangeListener(this);
        this.subpages = this.getAdmSubpages();
        this.installSubpages(this.subpages);
        this.eventBus = eventBus;
        eventBus.subscribe((Object)this);
    }

    protected void installSubpages(List<IPageController> subpages) {
        for (IPageController subpage : subpages) {
            if (subpage instanceof ConsolePage) {
                this.view.addSeperator(20);
            }
            this.view.addViewCard(subpage.getIcon(), subpage.getView(), subpage.getName());
        }
        this.view.setView(subpages.get(0).getName());
        this.currentPage = subpages.get(0);
    }

    protected List<IPageController> getAdmSubpages() {
        ArrayList<IPageController> res = new ArrayList<IPageController>();
        res.add(this.createAppsPage());
        res.add(this.createDGsPage());
        res.add(this.createVFsPage());
        res.add(this.createConsolePage());
        res.add(this.createLogsPage());
        return res;
    }

    protected IPageController createAppsPage() {
        FunctionType type = FunctionType.APPLICATIONS;
        AppsSubpageView view = new AppsSubpageView(type.getName());
        AppsPageController appsPage = new AppsPageController(type.getName(), type.getDescription(), type.getIcon(), view);
        return appsPage;
    }

    protected IPageController createDGsPage() {
        FunctionType type = FunctionType.DEVICE_GROUPS;
        DevicegroupsSubpageView view = new DevicegroupsSubpageView(type.getName());
        DevicegroupsPageController appsPage = new DevicegroupsPageController(type.getName(), type.getDescription(), type.getIcon(), view);
        return appsPage;
    }

    protected IPageController createVFsPage() {
        FunctionType type = FunctionType.VIRTUAL_FABRICS;
        VirtualFabricsSubpageView view = new VirtualFabricsSubpageView(type.getName());
        VirtualFabricsPageController appsPage = new VirtualFabricsPageController(type.getName(), type.getDescription(), type.getIcon(), view);
        return appsPage;
    }

    protected IPageController createBlankPage(FunctionType type) {
        BlankView view = new BlankView(type.getName());
        ConfPageController<Object, BlankView.BlankEditorPanel> page = new ConfPageController<Object, BlankView.BlankEditorPanel>(type.getName(), type.getDescription(), type.getIcon(), (AbstractConfView)view){

            @Override
            protected AbstractEditorController<Object, BlankView.BlankEditorPanel> creatEditorController(BlankView.BlankEditorPanel editorPanel) {
                return null;
            }

            @Override
            protected ArrayList<Item<Object>> initData() throws Exception {
                return null;
            }

            @Override
            protected Object getCopy(Object obj) {
                return null;
            }

            @Override
            protected Object createObj() {
                return null;
            }

            @Override
            protected void removeItemObject(String name) throws Exception {
            }

            @Override
            protected void saveItemObject(String oldName, Object obj) throws Exception {
            }

            @Override
            protected ValidationTask<Object> getValidationTask(ValidationDialog dialog, Item<Object> item) {
                return null;
            }

            @Override
            protected String getHelpID() {
                return null;
            }
        };
        return page;
    }

    protected IPageController createConsolePage() {
        ConsoleView consoleView = new ConsoleView();
        ConsoleDispatchManager dispatchManager = new ConsoleDispatchManager(consoleView, this.view.getOwner());
        consoleView.setConsoleDispatchManager(dispatchManager);
        ConsolePage consolePage = new ConsolePage(consoleView, this.view.getOwner(), dispatchManager, this.eventBus);
        return consolePage;
    }

    protected IPageController createLogsPage() {
        SMLogView smLogView = new SMLogView();
        SMLogModel smLogModel = new SMLogModel();
        SMLogController smLogController = new SMLogController(smLogModel, smLogView);
        LogPage logPage = new LogPage(smLogController);
        return logPage;
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        IProgressObserver[] subObservers = null;
        if (observer != null) {
            subObservers = observer.createSubObservers(this.subpages.size());
        }
        for (int i = 0; i < this.subpages.size(); ++i) {
            IPageController subpage = this.subpages.get(i);
            subpage.setContext(context, subObservers == null ? null : subObservers[i]);
        }
        if (context != null && context.getController() != null) {
            this.undoHandler = context.getController().getUndoHandler();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        NavigationPanel.IconPanel panel = (NavigationPanel.IconPanel)e.getSource();
        String name = panel.getName();
        IPageController newPage = null;
        for (IPageController page : this.subpages) {
            if (!page.getName().equals(name)) continue;
            newPage = page;
            break;
        }
        if (newPage != null) {
            IPageController oldPage = this.currentPage;
            boolean success = this.selectPage(newPage);
            if (success && this.undoHandler != null && !this.undoHandler.isInProgress()) {
                UndoableTabSelection undoSel = new UndoableTabSelection(this, oldPage, this.currentPage);
                this.undoHandler.addUndoAction(undoSel);
            }
        }
    }

    public boolean selectPage(IPageController page) {
        if (this.currentPage != null) {
            if (!this.currentPage.canExit()) {
                return false;
            }
            this.currentPage.onExit();
        }
        this.currentPage = page;
        this.view.setView(page.getName());
        page.onEnter();
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return STLConstants.K1058_ADMIN_DESCRIPTION.getValue();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public void cleanup() {
        for (IPageController subpage : this.subpages) {
            subpage.cleanup();
        }
    }

    @Override
    public void onEnter() {
        this.isShowing = true;
        if (this.currentPage != null) {
            this.currentPage.onEnter();
        }
    }

    @Override
    public void onExit() {
        if (this.currentPage != null) {
            this.currentPage.onExit();
        }
        this.isShowing = false;
    }

    @Override
    public boolean canExit() {
        if (this.currentPage != null && this.currentPage instanceof ConfPageController) {
            return this.currentPage.canExit();
        }
        return true;
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        if (this.isShowing && this.currentPage != null) {
            this.currentPage.onRefresh(observer);
        }
        if (observer != null) {
            observer.onFinish();
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.MEDIUM;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.MEDIUM;
    }

    public String toString() {
        return this.getName();
    }
}

