/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import com.intel.stl.api.management.devicegroups.IncludeGroup;
import com.intel.stl.ui.admin.impl.IRendererModel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.devicegroups.DGSelectRenderer;
import com.intel.stl.ui.admin.view.devicegroups.IncludeGroupRenderer;
import com.intel.stl.ui.admin.view.devicegroups.NodeDescRenderer;
import com.intel.stl.ui.admin.view.devicegroups.NodeGUIDRenderer;
import com.intel.stl.ui.admin.view.devicegroups.NodeTypeRenderer;
import com.intel.stl.ui.admin.view.devicegroups.PortGUIDRenderer;
import com.intel.stl.ui.admin.view.devicegroups.SystemImageGUIDRenderer;
import java.util.LinkedHashMap;
import java.util.Map;

public class DeviceGroupRendererModel
implements IRendererModel {
    private static final Map<String, Class<? extends IAttrRenderer<?>>> map = new LinkedHashMap<String, Class<? extends IAttrRenderer<?>>>(){
        private static final long serialVersionUID = -4676175893529648601L;
        {
            this.put("SystemImageGUID", SystemImageGUIDRenderer.class);
            this.put("NodeGUID", NodeGUIDRenderer.class);
            this.put("PortGUID", PortGUIDRenderer.class);
            this.put("NodeDesc", NodeDescRenderer.class);
            this.put("NodeType", NodeTypeRenderer.class);
            this.put("Select", DGSelectRenderer.class);
            this.put("IncludeGroup", IncludeGroupRenderer.class);
        }
    };
    private String[] dgNames;

    public void setDgNames(String[] dgNames) {
        this.dgNames = dgNames;
    }

    @Override
    public String[] getRendererNames() {
        return map.keySet().toArray(new String[0]);
    }

    @Override
    public IAttrRenderer<?> getRenderer(String name) throws Exception {
        Class<IAttrRenderer<?>> klass = map.get(name);
        if (klass != null) {
            IAttrRenderer<?> res = klass.newInstance();
            this.initRenderer(name, res);
            return res;
        }
        throw new IllegalArgumentException("Unknown renderer '" + name + "'");
    }

    protected void initRenderer(String name, IAttrRenderer<?> renderer) {
        if (name.equals("IncludeGroup")) {
            IncludeGroupRenderer lsRenderer = (IncludeGroupRenderer)renderer;
            lsRenderer.setList(IncludeGroup.toArry(this.dgNames));
        }
    }

    public String[] updateDGName(String oldName, String newName) {
        for (int i = 0; i < this.dgNames.length; ++i) {
            if (!this.dgNames[i].equals(oldName)) continue;
            this.dgNames[i] = newName;
            break;
        }
        return this.dgNames;
    }
}

