/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.AbstractEditorController;
import com.intel.stl.ui.admin.impl.ConfPageController;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.impl.devicegroups.DGValidationTask;
import com.intel.stl.ui.admin.impl.devicegroups.DevicegroupsEditorController;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.admin.view.devicegroups.DevicegroupsEditorPanel;
import com.intel.stl.ui.admin.view.devicegroups.DevicegroupsSubpageView;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

public class DevicegroupsPageController
extends ConfPageController<DeviceGroup, DevicegroupsEditorPanel> {
    private Set<String> reserved;

    public DevicegroupsPageController(String name, String description, ImageIcon icon, DevicegroupsSubpageView view) {
        super(name, description, icon, view);
    }

    @Override
    public String getHelpID() {
        return HelpAction.getInstance().getAdminDg();
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        super.setContext(context, observer);
        this.edtCtr.setContext(context);
        this.reserved = this.mgtApi.getReservedDeviceGroups();
    }

    @Override
    protected AbstractEditorController<DeviceGroup, DevicegroupsEditorPanel> creatEditorController(DevicegroupsEditorPanel editorPanel) {
        return new DevicegroupsEditorController(editorPanel);
    }

    @Override
    protected ArrayList<Item<DeviceGroup>> initData() throws Exception {
        List<DeviceGroup> groups = this.mgtApi.getDeviceGroups();
        ArrayList<Item<DeviceGroup>> res = new ArrayList<Item<DeviceGroup>>();
        for (DeviceGroup group : groups) {
            boolean isEditable = this.isEditable(group);
            Item<DeviceGroup> item = new Item<DeviceGroup>(res.size(), group.getName(), group, isEditable);
            item.setState(ChangeState.NONE);
            res.add(item);
        }
        return res;
    }

    private boolean isEditable(DeviceGroup group) {
        String name = group.getName();
        return !this.reserved.contains(name);
    }

    @Override
    protected DeviceGroup getCopy(DeviceGroup obj) {
        return obj.copy();
    }

    @Override
    protected DeviceGroup createObj() {
        return new DeviceGroup();
    }

    @Override
    protected void removeItemObject(String name) throws Exception {
        this.mgtApi.removeDeviceGroup(name);
    }

    @Override
    protected ValidationTask<DeviceGroup> getValidationTask(ValidationDialog dialog, Item<DeviceGroup> item) {
        DGValidationTask task = new DGValidationTask(dialog, this.valModel, this.orgItems, item, this.mgtApi);
        return task;
    }

    @Override
    protected void saveItemObject(String oldName, DeviceGroup obj) throws Exception {
        if (oldName != null) {
            this.mgtApi.updateDeviceGroup(oldName, obj);
        } else {
            this.mgtApi.addDeviceGroup(obj);
        }
    }
}

