/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.logs;

import com.intel.stl.ui.admin.impl.SMLogModel;
import com.intel.stl.ui.admin.impl.logs.SearchKey;
import com.intel.stl.ui.admin.impl.logs.SearchPositionBean;
import com.intel.stl.ui.admin.impl.logs.SearchState;
import com.intel.stl.ui.admin.view.logs.AbstractLogView;
import com.intel.stl.ui.common.Util;
import java.awt.Color;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultHighlighter;

public class SearchTask
extends SwingWorker<Void, Void> {
    private final AbstractLogView view;
    private final SMLogModel model;
    private final String text;
    private final List<SearchKey> searchKeys;
    private final SearchState searchState;

    public SearchTask(AbstractLogView view, SMLogModel model, String text, SearchState searchState, List<SearchKey> searchKeys) {
        this.view = view;
        this.model = model;
        this.text = text;
        this.searchState = searchState;
        this.searchKeys = searchKeys;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.model.resetSearchResults();
        if (this.searchKeys != null && !this.searchKeys.isEmpty()) {
            for (SearchKey searchKey : this.searchKeys) {
                if (searchKey == null) continue;
                String key = searchKey.getText();
                Color color = searchKey.getColor();
                this.search(this.searchState, key, color);
            }
        }
        return null;
    }

    protected void search(SearchState searchState, String searchKey, Color color) {
        if (searchKey == null) {
            return;
        }
        String newSearchKey = Pattern.quote(searchKey);
        Pattern pattern = Pattern.compile(newSearchKey);
        Matcher matcher = pattern.matcher(this.text);
        while (matcher.find()) {
            this.model.addSearchResult(new SearchPositionBean(searchKey, matcher.start(), matcher.end(), new DefaultHighlighter.DefaultHighlightPainter(color)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        try {
            this.get();
            this.view.saveLastSearchKey();
            this.view.highlightText(this.searchKeys, this.model.getSearchResults(), this.searchState);
            if (!this.model.getSearchResults().isEmpty()) {
                this.view.moveToText(this.model.getSearchResults().get(0).getStartOffset(), this.model.getSearchResults().get(0).getEndOffset());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            Util.showError(this.view, e);
            e.printStackTrace();
        }
        finally {
            this.view.enableSearch(true);
            List<SearchPositionBean> results = this.model.getSearchResults();
            if (results != null) {
                this.view.showNumMatches(this.model.getSearchResults().size());
            }
        }
    }
}

