/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.virtualfabrics;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.virtualfabrics.ApplicationName;
import com.intel.stl.api.management.virtualfabrics.LimitedMember;
import com.intel.stl.api.management.virtualfabrics.Member;
import com.intel.stl.ui.admin.impl.IRendererModel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.ApplicationRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.BandwidthRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.BaseSLRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.FlowControlDisableRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.HighPriorityRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.HoqLifeRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.LimitedMemberRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.MaxMtuRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.MaxRateRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.MemberRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PKeyRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PktLifeTimeMultRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.PreemptRankRenderer;
import com.intel.stl.ui.admin.view.virtualfabrics.StandbyRenderer;
import java.util.LinkedHashMap;
import java.util.Map;

public class VirtualFabricRendererModel
implements IRendererModel {
    private static final Map<String, Class<? extends IAttrRenderer<?>>> map = new LinkedHashMap<String, Class<? extends IAttrRenderer<?>>>(){
        private static final long serialVersionUID = 7007977245246746722L;
        {
            this.put("PKey", PKeyRenderer.class);
            this.put("MaxMTU", MaxMtuRenderer.class);
            this.put("MaxRate", MaxRateRenderer.class);
            this.put("Standby", StandbyRenderer.class);
            this.put("HighPriority", HighPriorityRenderer.class);
            this.put("Bandwidth", BandwidthRenderer.class);
            this.put("PktLifeTimeMult", PktLifeTimeMultRenderer.class);
            this.put("BaseSL", BaseSLRenderer.class);
            this.put("FlowControlDisable", FlowControlDisableRenderer.class);
            this.put("PreemptRank", PreemptRankRenderer.class);
            this.put("HoqLife", HoqLifeRenderer.class);
            this.put("Member", MemberRenderer.class);
            this.put("LimitedMember", LimitedMemberRenderer.class);
            this.put("Application", ApplicationRenderer.class);
        }
    };
    private String[] appNames;
    private String[] dgNames;

    public void setAppNames(String[] appNames) {
        this.appNames = appNames;
    }

    public void setDgNames(String[] dgNames) {
        this.dgNames = dgNames;
    }

    @Override
    public String[] getRendererNames() {
        return map.keySet().toArray(new String[0]);
    }

    @Override
    public IAttrRenderer<?> getRenderer(String name) throws Exception {
        Class<IAttrRenderer<?>> klass = map.get(name);
        if (klass != null) {
            IAttrRenderer<?> res = klass.newInstance();
            this.initRenderer(name, res);
            return res;
        }
        throw new IllegalArgumentException("Unknown renderer '" + name + "'");
    }

    protected void initRenderer(String name, IAttrRenderer<?> renderer) {
        if (name.equals("Member")) {
            MemberRenderer memebers = (MemberRenderer)renderer;
            IAttribute[] sns = new Member[this.dgNames.length];
            for (int i = 0; i < sns.length; ++i) {
                sns[i] = new Member(this.dgNames[i]);
            }
            memebers.setList(sns);
        } else if (name.equals("LimitedMember")) {
            LimitedMemberRenderer limitedMembers = (LimitedMemberRenderer)renderer;
            IAttribute[] sns = new LimitedMember[this.dgNames.length];
            for (int i = 0; i < sns.length; ++i) {
                sns[i] = new LimitedMember(this.dgNames[i]);
            }
            limitedMembers.setList(sns);
        } else if (name.equals("Application")) {
            ApplicationRenderer appMemebers = (ApplicationRenderer)renderer;
            IAttribute[] sns = new ApplicationName[this.appNames.length];
            for (int i = 0; i < sns.length; ++i) {
                sns[i] = new ApplicationName(this.appNames[i]);
            }
            appMemebers.setList(sns);
        }
    }

    public boolean isRepeatabledAttr(String name) {
        return name.equals("Member") || name.equals("LimitedMember") || name.equals("Application");
    }
}

